/*
Copyright (C) 2014 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.bean;

import com.clustercontrol.cloud.validation.annotation.ElementId;
import com.clustercontrol.cloud.validation.annotation.Identity;
import com.clustercontrol.cloud.validation.annotation.NotNull;
import com.clustercontrol.cloud.validation.annotation.Size;

/**
 * インスタンス作成時に紐付けるノードの詳細を保持するクラス。
 *
 */
public class NodeDetail {
	private String facilityId;
	private String facilityName;
	private String nodeName;
	private String description;
	private Boolean replaceNode;

	/**
	 * ファシリティ ID を取得する。
	 * 
	 * @return ファシリティ ID。
	 */
	@ElementId("facilityId")
	@Identity(groups={"addInstance", "addInstanceByTemplate", "restoreInstance", "RegistNodeRequest"})
	public String getFacilityId() {
		return facilityId;
	}
	/**
	 * ファシリティ ID を設定する。
	 * 
	 * @param facilityId ファシリティ ID。
	 */
	public void setFacilityId(String facilityId) {
		this.facilityId = facilityId;
	}
	/**
	 * ファシリティ名を取得する。
	 * 
	 * @return ファシリティ名。
	 */
	@ElementId("facilityName")
	@NotNull(groups={"addInstance"})
	@Size(max=128)
	public String getFacilityName() {
		return facilityName;
	}
	/**
	 * ファシリティ名を設定する。
	 * 
	 * @param facilityName ファシリティ名。
	 */
	public void setFacilityName(String facilityName) {
		this.facilityName = facilityName;
	}
	/**
	 * ノード名を取得する。
	 * 
	 * @return ノード名。
	 */
	@ElementId("nodeName")
	@NotNull(groups={"addInstance"})
	@Size(max=128)
	public String getNodeName() {
		return nodeName;
	}
	/**
	 * ノード名を設定する。
	 * 
	 * @param nodeName ノード名。
	 */
	public void setNodeName(String nodeName) {
		this.nodeName = nodeName;
	}
	/**
	 * ノードの説明を取得する。
	 * 
	 * @return ノードの説明。
	 */
	@ElementId("description")
	@NotNull(groups={"addInstance"})
	@Size(max=256)
	public String getDescription() {
		return description;
	}
	/**
	 * ノードの説明を設定する。
	 * 
	 * @param description ノードの説明。
	 */
	public void setDescription(String description) {
		this.description = description;
	}

	/**
	 * 既存のノードの更新を許可するフラグを取得する。
	 * このフラグは、インスタンスに紐付けるノードが既存の場合、ノードに設定された内容をこの情報で更新することを許可する場合 true、許可しない場合 false を指定する。
	 * 
	 * @return 既存のノードの更新を許可するフラグ。
	 */
	public Boolean getReplaceNode() {
		return replaceNode;
	}
	/**
	 * 既存のノードの更新を許可するフラグを設定する。
	 * 
	 * @param replaceNode 既存のノードの更新を許可するフラグ。
	 */
	public void setReplaceNode(Boolean replaceNode) {
		this.replaceNode = replaceNode;
	}
}
