/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.dao;

import java.util.List;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.IdClass;
import javax.persistence.OneToMany;
import javax.persistence.Table;

import com.clustercontrol.cloud.persistence.IDHolder;


/**
 * インスタンス情報のBMP Entity Bean クラス<BR>
 */
@Entity
@Table(name="cc_cloud_region")
@IdClass(CloudRegionDao.CloudRegionPK.class)
public class CloudRegionDao implements IDHolder {
	public static class CloudRegionPK implements java.io.Serializable {
		/**
		 * 
		 */
		private static final long serialVersionUID = 682905935857533293L;

		public String region;
		public String cloudServiceId;

		public CloudRegionPK() {
		}

		public CloudRegionPK(String cloudServiceId, String region) {
			this.cloudServiceId = cloudServiceId;
			this.region = region;
		}

		public String getRegion() {
			return region;
		}

		public void setRegion(String region) {
			this.region = region;
		}

		public String getCloudServiceId() {
			return cloudServiceId;
		}

		public void setCloudServiceId(String cloudServiceId) {
			this.cloudServiceId = cloudServiceId;
		}

		public int hashCode() {
			int _hashCode = 0;
			if (this.region != null)
				_hashCode += this.region.hashCode();
			if (this.cloudServiceId != null)
				_hashCode += this.cloudServiceId.hashCode();

			return _hashCode;
		}

		public boolean equals(Object obj) {
			if (!(obj instanceof CloudRegionPK))
				return false;

			CloudRegionPK pk = (CloudRegionPK) obj;
			boolean eq = true;

			if (this.region != null) {
				eq = eq && this.region.equals(pk.getRegion());
			} else
			{
				eq = eq && (pk.getRegion() == null);
			}
			if (this.cloudServiceId != null) {
				eq = eq
						&& this.cloudServiceId.equals(pk
								.getCloudServiceId());
			} else
			{
				eq = eq && (pk.getCloudServiceId() == null);
			}

			return eq;
		}

		public String toString() {
			StringBuffer toStringValue = new StringBuffer("[.");
			toStringValue.append(this.region).append('.');
			toStringValue.append(this.cloudServiceId).append('.');
			toStringValue.append(']');
			return toStringValue.toString();
		}

	}
	
	public String region;
	public String cloudServiceId;
	private String regionName;
	private String description;
	private List<CloudEndpointDao> endpoints;

	public CloudRegionDao()
	{
	}

	public CloudRegionDao(String region,String cloudServiceId,String regionName,String description,List<CloudEndpointDao> endpoints)
	{
		setRegion(region);
		setCloudServiceId(cloudServiceId);
		setRegionName(regionName);
		setDescription(description);
		setEndpoints(endpoints);
	}

	public CloudRegionDao( CloudRegionDao otherData )
	{
		setRegion(otherData.getRegion());
		setCloudServiceId(otherData.getCloudServiceId());
		setRegionName(otherData.getRegionName());
		setDescription(otherData.getDescription());
		setEndpoints(otherData.getEndpoints());
	}

	@Id
	@Column(name="region")
	public String getRegion() {
		return region;
	}

	public void setRegion(String region) {
		this.region = region;
	}

	@Id
	@Column(name="cloud_service_id")
	public String getCloudServiceId() {
		return cloudServiceId;
	}

	public void setCloudServiceId(String cloudServiceId) {
		this.cloudServiceId = cloudServiceId;
	}
	
	@Column(name="region_name")
	public String getRegionName()
	{
		return this.regionName;
	}
	public void setRegionName( String regionName )
	{
		this.regionName = regionName;
	}

	@Column(name="description")
	public String getDescription()
	{
		return this.description;
	}
	public void setDescription( String description )
	{
		this.description = description;
	}

	@OneToMany(fetch=FetchType.EAGER, mappedBy="region")
	public List<CloudEndpointDao> getEndpoints()
	{
		return this.endpoints;
	}
	public void setEndpoints(List<CloudEndpointDao> endpoints)
	{
		this.endpoints = endpoints;
	}
	
	public String toString()
	{
		StringBuffer str = new StringBuffer("{");

		str.append("region=" + getRegion() + " " + "cloudServiceId=" + getCloudServiceId() + " " + "regionName=" + getRegionName() + " " + "description=" + getDescription() + " " + "endpoints=" + getEndpoints());
		str.append('}');

		return(str.toString());
	}

	public boolean equals( Object pOther )
	{
		if( pOther instanceof CloudRegionDao )
		{
			CloudRegionDao lTest = (CloudRegionDao) pOther;
			boolean lEquals = true;

			if( this.region == null )
			{
				lEquals = lEquals && ( lTest.region == null );
			}
			else
			{
				lEquals = lEquals && this.region.equals( lTest.region );
			}
			if( this.cloudServiceId == null )
			{
				lEquals = lEquals && ( lTest.cloudServiceId == null );
			}
			else
			{
				lEquals = lEquals && this.cloudServiceId.equals( lTest.cloudServiceId );
			}
			if( this.regionName == null )
			{
				lEquals = lEquals && ( lTest.regionName == null );
			}
			else
			{
				lEquals = lEquals && this.regionName.equals( lTest.regionName );
			}
			if( this.description == null )
			{
				lEquals = lEquals && ( lTest.description == null );
			}
			else
			{
				lEquals = lEquals && this.description.equals( lTest.description );
			}
			if( this.endpoints == null )
			{
				lEquals = lEquals && ( lTest.endpoints == null );
			}
			else
			{
				lEquals = lEquals && this.endpoints.equals( lTest.endpoints );
			}

			return lEquals;
		}
		else
		{
			return false;
		}
	}

	public int hashCode()
	{
		int result = 17;

		result = 37*result + ((this.region != null) ? this.region.hashCode() : 0);

		result = 37*result + ((this.cloudServiceId != null) ? this.cloudServiceId.hashCode() : 0);

		result = 37*result + ((this.regionName != null) ? this.regionName.hashCode() : 0);

		result = 37*result + ((this.description != null) ? this.description.hashCode() : 0);

		result = 37*result + ((this.endpoints != null) ? this.endpoints.hashCode() : 0);

		return result;
	}

	@Override
	public CloudRegionDao.CloudRegionPK getId() {
		return new CloudRegionDao.CloudRegionPK(getCloudServiceId(), getRegion());
	}
}
