/*

Copyright (C) 2006 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.action;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.composite.FacilityTreeComposite;
import com.clustercontrol.repository.util.RepositoryEndpointWrapper;
import com.clustercontrol.ws.repository.FacilityTreeItem;

/**
 * スコープツリーアイテムを取得するクライアント側アクションクラス<BR>
 * 
 */
public class OwnerRoleFacilityTree extends FacilityTree {
	// ログ
	private Log m_log = LogFactory.getLog( OwnerRoleFacilityTree.class );

	private String ownerRoleId = null;

	private boolean isNode = false;

	public OwnerRoleFacilityTree(String ownerRoleId, boolean isNode) {
		super();
		this.ownerRoleId = ownerRoleId;
		this.isNode = isNode;
	}
	/**
	 * キャッシュのリフレッシュ
	 * 
	 * @return FacilityTreeItem
	 */
	@Override
	public FacilityTreeItem getTreeItem() {
		//m_log.debug("OwnerRoleFacilityTree.getTreeItem() : start");

		FacilityTreeItem item = null;
		try {
			if (this.isNode) {
				// ノードのみ取得
				item = RepositoryEndpointWrapper.getNodeFacilityTree(this.ownerRoleId);
			} else {
				item = RepositoryEndpointWrapper.getFacilityTree(this.ownerRoleId);
			}

		} catch (Exception e) {
			m_log.warn("getTreeItem(), " + e.getMessage(), e);
		}

		return item;
		//m_log.debug("OwnerRoleFacilityTree.getTreeItem() : stop");
	}

	/**
	 * キャッシュ更新時にリフレッシュするCompositeを一覧に追加
	 * 
	 * @param composite
	 */
	@Override
	public void addComposite(FacilityTreeComposite composite) {
		// オーナーロールIDの場合はキャッシュを使用しないため処理を行わない
	}

	/**
	 * キャッシュ更新時にリフレッシュするCompositeを一覧から削除
	 * 
	 * @param composite
	 */
	@Override
	public void delComposite(FacilityTreeComposite composite) {
		// オーナーロールIDの場合はキャッシュを使用しないため処理を行わない
	}
}