package com.clustercontrol.accesscontrol.view;

import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;

import com.clustercontrol.accesscontrol.composite.RoleListComposite;
import com.clustercontrol.accesscontrol.composite.action.RoleListSelectionChangedListener;
import com.clustercontrol.accesscontrol.view.action.RoleAddAction;
import com.clustercontrol.accesscontrol.view.action.RoleDeleteAction;
import com.clustercontrol.accesscontrol.view.action.RoleModifyAction;
import com.clustercontrol.bean.Property;
import com.clustercontrol.view.CommonViewPart;

/**
 * アクセス権限[ロール]ビュークラス<BR>
 * 
 * クライアントの画面を構成します。
 * 
 * @version 2.0.0
 * @since 2.0.0
 */
public class RoleListView extends CommonViewPart {
	/** ビューID */
	public static final String ID = "com.clustercontrol.accesscontrol.view.RoleListView";

	/** アクセス[ロール]ビュー用のコンポジット */
	private RoleListComposite m_roleList = null;

	/**
	 * コンストラクタ
	 */
	public RoleListView() {
		super();
	}

	/**
	 * ビューを構築します。
	 * 
	 * @param parent 親コンポジット
	 * 
	 * @see org.eclipse.ui.IWorkbenchPart#createPartControl(org.eclipse.swt.widgets.Composite)
	 * @see #createContextMenu()
	 * @see #update()
	 */
	@Override
	public void createPartControl(Composite parent) {
		GridLayout layout = new GridLayout(1, true);
		parent.setLayout(layout);
		layout.marginHeight = 0;
		layout.marginWidth = 0;

		m_roleList = new RoleListComposite(parent, SWT.NONE);
		GridData gridData = new GridData();
		gridData.horizontalAlignment = GridData.FILL;
		gridData.verticalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		gridData.grabExcessVerticalSpace = true;
		m_roleList.setLayoutData(gridData);

		//ポップアップメニュー作成
		createContextMenu();

		// ボタン（アクション）を制御するリスナーを登録
		this.m_roleList.getTableViewer().addSelectionChangedListener(
				new RoleListSelectionChangedListener());

		//ビューを更新
		this.update();
	}

	/**
	 * コンテキストメニューを作成します。
	 * 
	 * @see org.eclipse.jface.action.MenuManager
	 * @see org.eclipse.swt.widgets.Menu
	 */
	private void createContextMenu() {
		MenuManager menuManager = new MenuManager();
		menuManager.setRemoveAllWhenShown(true);
		menuManager.addMenuListener(new IMenuListener() {
			/* (non-Javadoc)
			 * @see org.eclipse.jface.action.IMenuListener#menuAboutToShow(org.eclipse.jface.action.IMenuManager)
			 */
			@Override
			public void menuAboutToShow(IMenuManager manager) {
				//メニュー項目設定
				fillContextMenu(manager);
			}
		});

		Menu menu = menuManager.createContextMenu(m_roleList.getTable());
		m_roleList.getTable().setMenu(menu);
	}

	/**
	 * コンテキストメニューに項目を追加します。
	 * 
	 * @param manager メニューマネージャ
	 * 
	 * @see org.eclipse.jface.action.IToolBarManager
	 * @see org.eclipse.jface.action.IMenuManager
	 */
	private void fillContextMenu(IMenuManager manager) {
		//ビューのアクションのインスタンスを取得
		IToolBarManager toolbar =
				this.getViewSite().getActionBars().getToolBarManager();
		ActionContributionItem roleAdd =
				(ActionContributionItem) toolbar.find(RoleAddAction.ID);
		ActionContributionItem roleModify =
				(ActionContributionItem) toolbar.find(RoleModifyAction.ID);
		ActionContributionItem roleDelete =
				(ActionContributionItem) toolbar.find(RoleDeleteAction.ID);

		//ポップアップメニューにアクションを追加
		manager.add(roleAdd.getAction());
		manager.add(roleModify.getAction());
		manager.add(roleDelete.getAction());
	}

	/**
	 * ビューを更新します。
	 * 
	 * @see com.clustercontrol.accesscontrol.composite.RoleListComposite#update()
	 * @see com.clustercontrol.accesscontrol.composite.RoleListComposite#update(Property)
	 */
	public void update() {
		this.m_roleList.update();
	}

	/**
	 * アカウント[ロール]ビュー用のコンポジットを返します。
	 * 
	 * @return アカウント[ロール]ビュー用のコンポジット
	 */
	public RoleListComposite getComposite() {
		return m_roleList;
	}

	/**
	 * ビューのアクションの有効/無効を設定します。
	 * 
	 * @param num 選択イベント数
	 * @param selection ボタン（アクション）を有効にするための情報
	 */
	public void setEnabledAction(int num, ISelection selection) {
		//ビューアクションの使用可/不可を設定
		super.setEnabledAction(RoleModifyAction.ID, selection);
		super.setEnabledAction(RoleDeleteAction.ID, selection);

		if (num > 0){
			super.setEnabledAction(RoleModifyAction.ID, true);
			super.setEnabledAction(RoleDeleteAction.ID, true);
		} else {
			super.setEnabledAction(RoleModifyAction.ID, false);
			super.setEnabledAction(RoleDeleteAction.ID, false);
		}
	}
}
