/*

Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.calendar.dialog;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.vafada.swtcalendar.SWTCalendar;
import org.vafada.swtcalendar.SWTCalendarEvent;
import org.vafada.swtcalendar.SWTCalendarListener;

import com.clustercontrol.bean.PropertyDefineConstant;
import com.clustercontrol.bean.RequiredFieldColorConstant;
import com.clustercontrol.calendar.action.AddCalendar;
import com.clustercontrol.calendar.action.GetCalendar;
import com.clustercontrol.calendar.action.ModifyCalendar;
import com.clustercontrol.composite.RoleIdListComposite;
import com.clustercontrol.composite.RoleIdListComposite.Mode;
import com.clustercontrol.dialog.CommonDialog;
import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.calendar.CalendarPatternInfo;
import com.clustercontrol.ws.calendar.Ymd;

/**
 * カレンダ[カレンダパターンの作成・変更]ダイアログクラス<BR>
 * 
 * @version 4.1.0
 * @since 4.1.0
 */
public class CalendarPatternDialog extends CommonDialog {
	/** */
	private Shell shell = null;
	/** カレンダコンポジット*/
	private SWTCalendar swtcal = null;
	/** ID*/
	private Text txtID = null;
	/** 名*/
	private Text txtName = null;
	/** 選択した日付を表示するSWTリスト*/
	private List dateViewSWTList = null;

	/** 選択した日付を保持するリスト*/
	private ArrayList<Ymd> m_ymdList;
	/** */
	private CalendarPatternInfo inputData = null;
	/** ID*/
	private String id = "";
	/** 作成 or 変更*/
	private int mode;

	/** */
	private Date dateBefore;
	/** */
	private Date date;
	/** オーナーロールID用テキスト */
	private RoleIdListComposite m_ownerRoleId = null;

	/**
	 * コンストラクタ
	 * 
	 * @param parent
	 * @since 1.0.0
	 */
	public CalendarPatternDialog(Shell parent) {
		super(parent);
	}
	/**
	 * コンストラクタ
	 * 
	 * @param parent
	 * @since 1.0.0
	 */
	public CalendarPatternDialog(Shell parent,String id,int mode) {
		super(parent);
		this.id = id;
		this.mode = mode;
	}

	/**
	 * ダイアログ作成
	 * 
	 * @see com.clustercontrol.dialog.CommonDialog#customizeDialog(org.eclipse.swt.widgets.Composite)
	 * @since 1.0.0
	 */
	@Override
	protected void customizeDialog(Composite parent) {

		shell = this.getShell();
		// タイトル
		shell.setText(Messages.getString("dialog.calendar.pattern.create.modify"));

		// ラベル
		GridData gridData = new GridData();
		GridLayout layout = new GridLayout(1, false);
		layout.marginWidth = 20;
		layout.marginHeight = 10;
		layout.numColumns = 12;
		parent.setLayout(layout);
		/*
		 * カレンダパターンID
		 */
		//ラベル
		Label lblId = new Label(parent, SWT.LEFT);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		lblId.setLayoutData(gridData);
		lblId.setText(Messages.getString("calendar.pattern.id") + " : ");
		//テキスト
		txtID = new Text(parent, SWT.BORDER);
		gridData = new GridData();
		gridData.horizontalSpan = 8;
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		txtID.setLayoutData(gridData);
		txtID.addModifyListener(new ModifyListener(){
			@Override
			public void modifyText(ModifyEvent arg0) {
				update();
			}
		});

		Label label = new Label(parent, SWT.LEFT);
		gridData = new GridData();
		gridData.horizontalSpan = 3;
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		label.setLayoutData(gridData);
		label.setText("");

		/*
		 * カレンダパターン名
		 */
		//ラベル
		Label lblName = new Label(parent, SWT.LEFT);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		lblName.setLayoutData(gridData);
		lblName.setText(Messages.getString("calendar.pattern.name") + " : ");
		//テキスト
		txtName = new Text(parent, SWT.BORDER);
		gridData = new GridData();
		gridData.horizontalSpan = 8;
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		txtName.setLayoutData(gridData);
		txtName.addModifyListener(new ModifyListener(){
			@Override
			public void modifyText(ModifyEvent arg0) {
				update();
			}
		});

		label = new Label(parent, SWT.LEFT);
		gridData = new GridData();
		gridData.horizontalSpan = 3;
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		label.setLayoutData(gridData);
		label.setText("");

		/*
		 * オーナーロールID
		 */
		Label labelRoleId = new Label(parent, SWT.LEFT);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		labelRoleId.setLayoutData(gridData);
		labelRoleId.setText(Messages.getString("owner.role.id") + " : ");
		if (this.mode == PropertyDefineConstant.MODE_ADD
				|| this.mode == PropertyDefineConstant.MODE_COPY) {
			this.m_ownerRoleId = new RoleIdListComposite(parent, SWT.NONE, true, Mode.OWNER_ROLE);
		} else {
			this.m_ownerRoleId = new RoleIdListComposite(parent, SWT.NONE, false, Mode.OWNER_ROLE);
		}
		gridData = new GridData();
		gridData.horizontalSpan = 8;
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		m_ownerRoleId.setLayoutData(gridData);

		/*
		 * 例外日設定グループ
		 */
		//
		Group groupEtc = new Group(parent, SWT.CENTER);
		gridData = new GridData();
		gridData.horizontalAlignment = GridData.FILL;
		gridData.verticalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		gridData.grabExcessVerticalSpace = true;
		gridData.horizontalSpan = 12;
		layout = new GridLayout(12, false);
		layout.marginWidth = 5;
		layout.marginHeight = 5;

		groupEtc.setLayout(layout);
		groupEtc.setLayoutData(gridData);
		groupEtc.setText(Messages.getString("calendar.pattern.setting"));
		swtcal = new SWTCalendar(groupEtc);
		gridData = new GridData();
		gridData.horizontalAlignment = GridData.FILL;
		gridData.verticalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		gridData.grabExcessVerticalSpace = true;
		gridData.horizontalSpan = 5;
		gridData.verticalSpan = 2;

		swtcal.setLayoutData(gridData);
		//カレンダー日付変更時リスナー
		swtcal.addSWTCalendarListener(new SWTCalendarListener(){

			@Override
			public void dateChanged(SWTCalendarEvent event) {
				Date dateBuffer = event.getCalendar().getTime();

				//取得した日付をYmd型へ変換
				SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
				String selectDate = sdf.format(dateBuffer);
				String[] selectYmd = selectDate.split("/");
				Ymd selectDay = new Ymd();
				selectDay.setYear(Integer.parseInt(selectYmd[0]));
				selectDay.setMonth(Integer.parseInt(selectYmd[1]));
				selectDay.setDay(Integer.parseInt(selectYmd[2]));

				//登録の有無を確認する
				Boolean flag = false;
				Ymd delYMD = new Ymd();
				for(Ymd ymd : m_ymdList){
					if(equalsYmd(ymd,selectDay)){
						flag = true;
						delYMD = ymd;
						break;
					}
				}
				if(flag){
					//登録済みTRUE の場合、リストから削除
					m_ymdList.remove(delYMD);
				}else {
					//未登録FALSE の場合、リストに追加
					m_ymdList.add(selectDay);
				}
				//昇順ソート
				Collections.sort(m_ymdList, new Comparator<Ymd>(){
					@Override
					public int compare(Ymd y1, Ymd y2) {
						/**
						 * ex)
						 * year = 2013 * 10000
						 * month = 11 * 100
						 * day = 30
						 * int ymd = 20130000 + 1100 + 30 = 20131130
						 */
						int ymd1 = y1.getYear() * 10000 + y1.getMonth() * 100 + y1.getDay();
						int ymd2 = y2.getYear() * 10000 + y2.getMonth() * 100 + y2.getDay();
						return ymd1 - ymd2;
					}
				});
				//表示用SWTリストリセット
				dateViewSWTList.removeAll();
				for(Ymd ymd : m_ymdList){
					//表示用リストに格納
					dateViewSWTList.add(yyyyMMdd(ymd));
				}
				update();
			}
		});
		swtcal.updateCalendar(m_ymdList);
		//ラベル
		Label lbl = new Label(groupEtc, SWT.CENTER);
		gridData = new GridData();
		gridData.horizontalSpan = 5;
		gridData.verticalSpan = 1;
		lbl.setLayoutData(gridData);
		lbl.setText(" " + Messages.getString("calendar.pattern.record.date"));
		dateViewSWTList = new List(groupEtc,SWT.MULTI|SWT.BORDER|SWT.V_SCROLL);
		gridData = new GridData();
		gridData.horizontalAlignment = GridData.FILL;
		gridData.verticalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		gridData.grabExcessVerticalSpace = true;
		gridData.horizontalSpan = 5;
		gridData.verticalSpan = 1;
		dateViewSWTList.setLayoutData(gridData);
		// ダイアログを調整
		this.adjustDialog();
		//ダイアログに情報反映
		this.reflectCalendar();

		//更新
		update();
	}
	/**
	 * ダイアログエリアを調整します。
	 * 
	 */
	private void adjustDialog(){
		// サイズを最適化
		// グリッドレイアウトを用いた場合、こうしないと横幅が画面いっぱいになります。
		shell.pack();
		shell.setSize(new Point(420, shell.getSize().y));

		// 画面中央に配置
		Display display = shell.getDisplay();
		shell.setLocation((display.getBounds().width - shell.getSize().x) / 2,
				(display.getBounds().height - shell.getSize().y) / 2);
	}
	/**
	 * ２つのYmd型が等しいか判定
	 * @param y1
	 * @param y2
	 * @return 等しい true 等しくない false
	 */
	private boolean equalsYmd(Ymd y1, Ymd y2){
		if(y1.getYear().equals(y2.getYear())){
			if(y1.getMonth().equals(y2.getMonth())){
				if(y1.getDay().equals(y2.getDay())){
					return true;
				}
			}
		}
		return false;
	}
	/**
	 * Ymd(
	 * Integer year
	 * Integer month
	 * Integer day
	 * )をyyyy/MM/ddのString型へ変換する
	 * @param ymd
	 * @return
	 */
	private String yyyyMMdd(Ymd ymd){
		return ymd.getYear() + "/" + ymd.getMonth() + "/" + ymd.getDay();
	}

	/**
	 * 更新処理
	 * 
	 */
	private void update(){
		// 必須項目を明示
		// IDのインデックス：9
		if("".equals(this.txtID.getText())){
			this.txtID.setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
		}else{
			this.txtID.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
		}
		// 名のインデックス：9
		if("".equals(this.txtName.getText())){
			this.txtName.setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
		}else{
			this.txtName.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
		}
		//SWTカレンダ更新
		swtcal.updateCalendar(m_ymdList);
	}
	/**
	 * ダイアログにカレンダパターン情報を反映します。
	 */
	private void reflectCalendar() {
		// 初期表示
		CalendarPatternInfo info = null;
		if(mode == PropertyDefineConstant.MODE_MODIFY
				|| mode == PropertyDefineConstant.MODE_COPY){
			// 変更、コピーの場合、情報取得
			info = new GetCalendar().getCalendarPattern(this.id);
		}else{
			// 作成の場合
			info = new CalendarPatternInfo();
		}
		this.inputData = info;
		this.m_ymdList = new ArrayList<Ymd>();
		//カレンダ[カレンダパターン]情報取得
		if(info != null){
			if (info.getId() != null) {
				this.id = info.getId();
				this.txtID.setText(info.getId());
				//カレンダパターン定義変更の際にはカレンダパターンIDは変更不可
				if (this.mode == PropertyDefineConstant.MODE_MODIFY) {
					this.txtID.setEnabled(false);
				}
			}
			if(info.getName() != null){
				this.txtName.setText(info.getName());
			}
			if(info.getYmd() != null){
				for(Ymd ymd : info.getYmd()){
					m_ymdList = (ArrayList<Ymd>) info.getYmd();
					dateViewSWTList.add(yyyyMMdd(ymd));
				}
			}
			else {
				m_ymdList = new ArrayList<Ymd>();
			}
		}

		// オーナーロールID取得
		if (inputData.getOwnerRoleId() != null) {
			this.m_ownerRoleId.setText(inputData.getOwnerRoleId());
		}

		this.update();
	}
	/**
	 * ダイアログの情報からカレンダ情報を作成します。
	 * @return
	 */
	private ValidateResult createCalendarIrregularInfo() {
		ValidateResult result = null;

		Long regDate = inputData.getRegDate();
		String regUser = inputData.getRegUser();

		inputData = new CalendarPatternInfo();
		//カレンダパターンID取得
		if(txtID.getText().length() > 0){
			inputData.setId(txtID.getText());
		} else {
			result = new ValidateResult();
			result.setValid(false);
			result.setID(Messages.getString("message.hinemos.1"));
			result.setMessage(Messages.getString("calendar.pattern.id"));
			return result;
		}
		//カレンダパターン名取得
		if(txtName.getText().length() > 0){
			inputData.setName(txtName.getText());
		} else {
			result = new ValidateResult();
			result.setValid(false);
			result.setID(Messages.getString("message.hinemos.1"));
			result.setMessage(Messages.getString("calendar.pattern.name"));
			return result;
		}
		//登録日取得
		if(m_ymdList == null){
			m_ymdList = new ArrayList<Ymd>();
		}
		for(Ymd ymd : m_ymdList){
			inputData.getYmd().add(ymd);
		}
		inputData.setRegDate(regDate);
		inputData.setRegUser(regUser);


		//オーナーロールID
		if (m_ownerRoleId.getText().length() > 0) {
			inputData.setOwnerRoleId(m_ownerRoleId.getText());
		} else {
			result = new ValidateResult();
			result.setValid(false);
			result.setID(Messages.getString("message.hinemos.1"));
			result.setMessage(Messages.getString("owner.role.id"));
			return result;
		}
		return result;
	}

	/**
	 * キャンセルボタンクリック時の処理
	 * 
	 * @see org.eclipse.jface.dialogs.Dialog#cancelPressed()
	 * @since 1.0.0
	 */
	@Override
	protected void cancelPressed() {
		date = dateBefore;

		super.cancelPressed();
	}
	/**
	 * OKボタンクリック時の処理
	 * 
	 * @see org.eclipse.jface.dialogs.Dialog#okPressed()
	 * @since 1.0.0
	 */
	@Override
	protected void okPressed() {
		date = swtcal.getCalendar().getTime();
		Calendar work = Calendar.getInstance();
		work.setTime(date);
		work.set(Calendar.MILLISECOND, 0);
		date = work.getTime();
		super.okPressed();
	}

	@Override
	protected ValidateResult validate() {
		return null;
	}
	@Override
	protected boolean action() {
		boolean result = false;
		createCalendarIrregularInfo();
		CalendarPatternInfo info = this.inputData;
		if(info != null){
			if(mode == PropertyDefineConstant.MODE_ADD){
				// 作成の場合+
				info = this.inputData;
				result = new AddCalendar().addCalendarPatternInfo(info);
			} else if (mode == PropertyDefineConstant.MODE_MODIFY){
				// 変更の場合
				info.setId(txtID.getText());
				result = new ModifyCalendar().modifyPatternInfo(info);
			} else if(mode == PropertyDefineConstant.MODE_COPY){
				// コピーの場合
				info.setId(txtID.getText());
				result = new AddCalendar().addCalendarPatternInfo(info);
			}
		} else {
			//m_log.error("info is null");
		}
		return result;
	}
}
