/*

 Copyright (C) 2006 NTT DATA Corporation

 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation, version 2.

 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.jobmanagement.composite.action;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

import com.clustercontrol.accesscontrol.action.CheckPermission;
import com.clustercontrol.accesscontrol.bean.FunctionConstant;
import com.clustercontrol.accesscontrol.bean.PrivilegeConstant.SystemPrivilegeMode;
import com.clustercontrol.composite.RoleIdListComposite;
import com.clustercontrol.jobmanagement.bean.JobConstant;
import com.clustercontrol.jobmanagement.dialog.JobTreeDialog;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.jobmanagement.JobTreeItem;

/**
 * ジョブID参照ボタンSelectionAdapterクラス<BR>
 * 
 * @version 2.1.0
 * @since 2.1.0
 */
public class JobIdSelectionListener extends SelectionAdapter {

	/** ジョブユニットID */
	private Text m_textJobunitId = null;

	/** ジョブID */
	private Text m_textJobId = null;

	/** オーナーロールID用テキスト */
	private RoleIdListComposite m_ownerRoleId = null;

	public JobIdSelectionListener(Text jobunitId, Text jobId, RoleIdListComposite ownerRoleId) {
		super();
		this.m_textJobunitId = jobunitId;
		this.m_textJobId = jobId;
		this.m_ownerRoleId = ownerRoleId;
	}

	/* (非 Javadoc)
	 * @see org.eclipse.swt.events.SelectionAdapter#widgetSelected(org.eclipse.swt.events.SelectionEvent)
	 */
	@Override
	public void widgetSelected(SelectionEvent e) {

		// 現在のユーザがジョブ実行権限を持たない場合、ジョブツリーダイアログを表示しない。
		boolean permission = new CheckPermission().check(FunctionConstant.JOBMANAGEMENT, SystemPrivilegeMode.EXEC);

		if(!permission){
			// アクセス権なしの場合、エラーダイアログを表示する
			MessageDialog.openInformation(null, Messages.getString("message"),
					Messages.getString("message.accesscontrol.16"));
			return;
		}

		//シェルを取得
		Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();

		// ジョブツリーダイアログ表示
		JobTreeDialog dialog = new JobTreeDialog(shell, this.m_ownerRoleId.getText());
		if (dialog.open() == IDialogConstants.OK_ID) {
			JobTreeItem selectItem = dialog.getSelectItem();
			if (selectItem.getData().getType() != JobConstant.TYPE_COMPOSITE) {
				m_textJobId.setText(selectItem.getData().getId());
				m_textJobunitId.setText(selectItem.getData().getJobunitId());
			} else {
				m_textJobId.setText("");
				m_textJobunitId.setText("");
			}
		}
	}
}