package com.clustercontrol.notify.util;

import java.util.List;

import javax.xml.ws.WebServiceException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.util.EndpointManager;
import com.clustercontrol.util.EndpointManager.EndpointSetting;
import com.clustercontrol.ws.notify.HinemosUnknown_Exception;
import com.clustercontrol.ws.notify.InvalidRole_Exception;
import com.clustercontrol.ws.notify.InvalidSetting_Exception;
import com.clustercontrol.ws.notify.InvalidUserPass_Exception;
import com.clustercontrol.ws.notify.NotifyDuplicate_Exception;
import com.clustercontrol.ws.notify.NotifyEndpoint;
import com.clustercontrol.ws.notify.NotifyInfo;
import com.clustercontrol.ws.notify.NotifyNotFound_Exception;

/**
 * Hinemosマネージャとの通信をするクラス。
 * HAのような複数マネージャ対応のため、このクラスを実装する。
 * 
 * Hinemosマネージャと通信できない場合は、WebServiceExceptionがthrowされる。
 * WebServiceExeptionが出力された場合は、もう一台のマネージャと通信する。
 */
public class NotifyEndpointWrapper {

	// ログ
	private static Log m_log = LogFactory.getLog( NotifyEndpointWrapper.class );

	public static boolean addNotify(NotifyInfo notifyInfo) throws HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception, NotifyDuplicate_Exception, InvalidSetting_Exception {
		WebServiceException wse = null;
		for (EndpointSetting endpointSetting : EndpointManager.getNotifyEndpoint()) {
			try {
				NotifyEndpoint endpoint = (NotifyEndpoint) endpointSetting.getEndpoint();
				return endpoint.addNotify(notifyInfo);
			} catch (WebServiceException e) {
				wse = e;
				m_log.warn("addNotify(), " + e.getMessage(), e);
				EndpointManager.changeEndpoint();
			}
		}
		throw wse;
	}

	public static boolean modifyNotify(NotifyInfo notifyInfo) throws HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception, NotifyDuplicate_Exception, InvalidSetting_Exception {
		WebServiceException wse = null;
		for (EndpointSetting endpointSetting : EndpointManager.getNotifyEndpoint()) {
			try {
				NotifyEndpoint endpoint = (NotifyEndpoint) endpointSetting.getEndpoint();
				return endpoint.modifyNotify(notifyInfo);
			} catch (WebServiceException e) {
				wse = e;
				m_log.warn("modifyNotify(), " + e.getMessage(), e);
				EndpointManager.changeEndpoint();
			}
		}
		throw wse;
	}

	public static boolean deleteNotify(String notifyId) throws HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception, NotifyNotFound_Exception {
		WebServiceException wse = null;
		for (EndpointSetting endpointSetting : EndpointManager.getNotifyEndpoint()) {
			try {
				NotifyEndpoint endpoint = (NotifyEndpoint) endpointSetting.getEndpoint();
				return endpoint.deleteNotify(notifyId);
			} catch (WebServiceException e) {
				wse = e;
				m_log.warn("deleteNotify(), " + e.getMessage(), e);
				EndpointManager.changeEndpoint();
			}
		}
		throw wse;
	}

	public static List<String> checkNotifyId(String notifyId) throws HinemosUnknown_Exception, NotifyNotFound_Exception, InvalidRole_Exception, InvalidUserPass_Exception {
		WebServiceException wse = null;
		for (EndpointSetting endpointSetting : EndpointManager.getNotifyEndpoint()) {
			try {
				NotifyEndpoint endpoint = (NotifyEndpoint) endpointSetting.getEndpoint();
				return endpoint.checkNotifyId(notifyId);
			} catch (WebServiceException e) {
				wse = e;
				m_log.warn("checkNotifyId(), " + e.getMessage(), e);
				EndpointManager.changeEndpoint();
			}
		}
		throw wse;
	}

	public static NotifyInfo getNotify(String notifyId) throws HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception, NotifyNotFound_Exception {
		WebServiceException wse = null;
		for (EndpointSetting endpointSetting : EndpointManager.getNotifyEndpoint()) {
			try {
				NotifyEndpoint endpoint = (NotifyEndpoint) endpointSetting.getEndpoint();
				return endpoint.getNotify(notifyId);
			} catch (WebServiceException e) {
				wse = e;
				m_log.warn("getNotify(), " + e.getMessage(), e);
				EndpointManager.changeEndpoint();
			}
		}
		throw wse;
	}

	public static List<NotifyInfo> getNotifyList() throws HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception, NotifyNotFound_Exception {
		WebServiceException wse = null;
		for (EndpointSetting endpointSetting : EndpointManager.getNotifyEndpoint()) {
			try {
				NotifyEndpoint endpoint = (NotifyEndpoint) endpointSetting.getEndpoint();
				return endpoint.getNotifyList();
			} catch (WebServiceException e) {
				wse = e;
				m_log.warn("getNotifyList(), " + e.getMessage(), e);
				EndpointManager.changeEndpoint();
			}
		}
		throw wse;
	}

	public static List<NotifyInfo> getNotifyListByOwnerRole(String ownerRoleId) throws HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception, NotifyNotFound_Exception {
		WebServiceException wse = null;
		for (EndpointSetting endpointSetting : EndpointManager.getNotifyEndpoint()) {
			try {
				NotifyEndpoint endpoint = (NotifyEndpoint) endpointSetting.getEndpoint();
				return endpoint.getNotifyListByOwnerRole(ownerRoleId);
			} catch (WebServiceException e) {
				wse = e;
				m_log.warn("getNotifyListByOwnerRole(), " + e.getMessage(), e);
				EndpointManager.changeEndpoint();
			}
		}
		throw wse;
	}

	public static void setNotifyStatus(String notifyId, boolean validFlag) throws NotifyNotFound_Exception, NotifyDuplicate_Exception, HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception{
		WebServiceException wse = null;
		for (EndpointSetting endpointSetting : EndpointManager.getNotifyEndpoint()) {
			try {
				NotifyEndpoint endpoint = (NotifyEndpoint) endpointSetting.getEndpoint();
				endpoint.setNotifyStatus(notifyId, validFlag);
				return;
			} catch (WebServiceException e) {
				wse = e;
				m_log.warn("setNotifyStatus(), " + e.getMessage(), e);
				EndpointManager.changeEndpoint();
			}
		}
		throw wse;
	}
}
