/*

Copyright (C) 2006 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.performance.view.action;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

import com.clustercontrol.performance.view.PerformanceGraphView;

/**
 * 性能グラフビューの更新アクション<BR>
 * 
 * @version 4.0.0
 * @since 4.0.0
 */
public class RefreshPerformanceGraphAction implements IViewActionDelegate {
	private static Log log = LogFactory.getLog(RefreshPerformanceGraphAction.class);

	public static final String ID = "com.clustercontrol.performance.view.action.RefreshPerformanceGraphAction";

	/**
	 * 更新アクション
	 */
	@Override
	public void run(IAction action) {
		log.debug("run()");

		IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();

		// 同じクラスのViewを複数作るため、IDで特定不可
		// アクティブなviewを取得する
		String viewTitle = page.getActivePart().getTitle();
		IViewReference[] refs = page.getViewReferences();
		for (IViewReference ref : refs) {

			if (ref.getView(false) instanceof PerformanceGraphView) {
				PerformanceGraphView view = (PerformanceGraphView) ref.getView(false);
				if (view.getTitle().equals(viewTitle)) {
					log.debug("run() viewTitle = " + viewTitle);
					view.update();
				}
			}
		}

	}

	/**
	 * 選択時
	 */
	@Override
	public void selectionChanged(IAction action, ISelection selection) {
	}

	/**
	 * 初期化
	 */
	@Override
	public void init(IViewPart view) {
	}

}
