package com.clustercontrol.plugin.menu;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;

import com.clustercontrol.ClusterControlPlugin;

public abstract class LoadMenuPlugin {
	public static List<String> getExtensionMenuList(){
		List<String> extensionMenuList = new ArrayList<String>();
		IExtensionRegistry registry = Platform.getExtensionRegistry();

		// 拡張ポイントを取得
		IExtensionPoint point = registry.getExtensionPoint(ClusterControlPlugin.getDefault().getBundle().getSymbolicName() + ".menuPlugin");

		for(IExtension extension: point.getExtensions()){
			for(IConfigurationElement element: extension.getConfigurationElements()){
				String menuId = null;
	
				// 要素名がMenuPluginだった場合、actionsetのIDを取得
				if(element.getName().equals("menuPlugin")){
					menuId = element.getAttribute("action_set_id");
				}
				
				if(menuId != null){
					extensionMenuList.add(menuId);
				}
			}
		}
		return new ArrayList<String>(extensionMenuList);
	}
}
