/*

Copyright (C) 2006 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.repository.view.action;

import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

import com.clustercontrol.ClusterControlPlugin;
import com.clustercontrol.bean.YesNoConstant;
import com.clustercontrol.fault.HinemosException;
import com.clustercontrol.repository.action.GetNodeListTableDefine;
import com.clustercontrol.repository.preference.RepositoryPreferencePage;
import com.clustercontrol.repository.util.RepositoryEndpointWrapper;
import com.clustercontrol.repository.view.NodeListView;
import com.clustercontrol.util.CommandCreator;
import com.clustercontrol.util.CommandExecutor;
import com.clustercontrol.util.Messages;
import com.clustercontrol.util.CommandCreator.PlatformType;
import com.clustercontrol.ws.repository.InvalidRole_Exception;

/**
 * プログラム実行を行うクライアント側アクションクラス<BR>
 * 
 * @version 4.1.0
 * @since 4.1.0
 */
public class ProgramExecutionAction implements IViewActionDelegate {

	// ログ
	private static Log m_log = LogFactory.getLog( ProgramExecutionAction.class );

	public static final String ID = "com.clustercontrol.repository.view.action.ProgramExecutionAction";

	//	 ----- instance フィールド ----- //

	private IViewPart viewPart; // ビュー

	// ----- instance メソッド ----- //

	/**
	 * @see org.eclipse.ui.IViewActionDelegate#init(org.eclipse.ui.IViewPart)
	 */
	@Override
	public void init(IViewPart viewPart) {
		this.viewPart = viewPart;
	}

	/**
	 * @see org.eclipse.ui.IActionDelegate#run(org.eclipse.jface.action.IAction)
	 */
	@Override
	public void run(IAction action) {
		// ノード一覧より、選択されているノードのファシリティIDを取得

		NodeListView view = (NodeListView) this.viewPart
				.getAdapter(NodeListView.class);

		StructuredSelection selection = (StructuredSelection) view
				.getComposite().getTableViewer().getSelection();

		List list = (List) selection.getFirstElement();
		String facilityId = null;

		if (list != null) {
			facilityId = (String) list.get(GetNodeListTableDefine.FACILITY_ID);
		}

		if (facilityId != null) {

			// プレファレンスページよりプログラム実行文字列を取得
			String execProg = ClusterControlPlugin.getDefault().getPreferenceStore().getString(
					RepositoryPreferencePage.P_PROGRAM_EXECUTION);

			// プログラム実行文字列の空チェック
			if (execProg.equals("")) {
				MessageDialog.openWarning(
						null,
						Messages.getString("warning"),
						Messages.getString("message.repository.49"));
				return;
			}

			// 置換対象文字列が含まれているか「#」の有無で確認する
			if (execProg.indexOf("#") != -1) {
				try {
					// マネージャへ文字列を送り置換したもので置き換える
					execProg = RepositoryEndpointWrapper.replaceNodeVariable(facilityId, execProg);
				} catch (InvalidRole_Exception e) {
					// アクセス権なしの場合、エラーダイアログを表示する
					MessageDialog.openInformation(
							null,
							Messages.getString("message"),
							Messages.getString("message.accesscontrol.16"));
				} catch (Exception e) {
					m_log.warn("run(), " + e.getMessage(), e);
					MessageDialog.openError(
							null,
							Messages.getString("failed"),
							Messages.getString("message.hinemos.failure.unexpected") + ", " + e.getMessage());
				}
			}
			
			// 実行コマンドを実行できるように変形
			String[] args = null;
			try {
				String user = System.getProperty("user.name");
				args = CommandCreator.createCommand(user, execProg, PlatformType.WINDOWS, YesNoConstant.TYPE_NO);
			} catch (HinemosException e) {
				m_log.warn("run(), " + e.getMessage(), e);
				MessageDialog.openError(
						null,
						Messages.getString("failed"),
						Messages.getString("message.hinemos.failure.unexpected") + ", " + e.getMessage());
			}
			
			String message = "";
			for (String arg : args) {
				message += arg + " ";
			}
			
			if (MessageDialog.openConfirm(
					null,
					Messages.getString("confirmed"),
					Messages.getString("message.repository.46", new String[]{message}))) {

				// 実行する
				m_log.debug("program execution start : " + message);
				try {
					new CommandExecutor(args).execute();
				} catch (Exception e) {
					MessageDialog.openError(
							null,
							Messages.getString("failed"),
							Messages.getString("message.repository.48") + ", " + e.getMessage());
				}
			}

		}
	}

	/**
	 * @see org.eclipse.ui.IActionDelegate#selectionChanged(org.eclipse.jface.action.IAction,
	 *      org.eclipse.jface.viewers.ISelection)
	 */
	@Override
	public void selectionChanged(IAction action, ISelection selection) {
	}
}