/*

Copyright (C) 2006 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.collectiverun.bean;

import java.io.Serializable;

import javax.xml.bind.annotation.XmlType;

/**
 * 一括制御の終了状態を保持するクラスです。
 * 
 * @version 2.1.0
 * @since 2.1.0
 */
@XmlType(namespace = "http://collectiverun.ws.clustercontrol.com")
public class EndStatusInfo implements Serializable, Cloneable {
	private static final long serialVersionUID = -2223379546670283637L;

	/** 終了状態 */
	private Integer endStatus = new Integer(0);

	/** 終了値範囲(開始) */
	private Integer startRangeValue = new Integer(0);

	/** 終了値範囲(終了) */
	private Integer endRangeValue = new Integer(0);

	/**
	 * @return Returns the endRangeValue.
	 * @since 1.0.0
	 */
	public Integer getEndRangeValue() {
		return endRangeValue;
	}

	/**
	 * @param endRangeValue
	 *            The endRangeValue to set.
	 * @since 1.0.0
	 */
	public void setEndRangeValue(Integer endRangeValue) {
		this.endRangeValue = endRangeValue;
	}

	/**
	 * @return Returns the startRangeValue.
	 * @since 1.0.0
	 */
	public Integer getStartRangeValue() {
		return startRangeValue;
	}

	/**
	 * @param startRangeValue
	 *            The startRangeValue to set.
	 * @since 1.0.0
	 */
	public void setStartRangeValue(Integer startRangeValue) {
		this.startRangeValue = startRangeValue;
	}

	/**
	 * @return Returns the endStatus.
	 * @since 1.0.0
	 */
	public Integer getEndStatus() {
		return endStatus;
	}

	/**
	 * @param type
	 *            The endStatus to set.
	 * @since 1.0.0
	 */
	public void setEndStatus(Integer endStatus) {
		this.endStatus = endStatus;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#clone()
	 * @since 2.1.0
	 */
	@Override
	public Object clone() {
		try {
			EndStatusInfo clone = (EndStatusInfo)super.clone();

			clone.setEndStatus(this.getEndStatus());
			clone.setStartRangeValue(this.getStartRangeValue());
			clone.setEndRangeValue(this.getEndRangeValue());

			return clone;
		} catch (CloneNotSupportedException e) {
			return null;
		}
	}
}