/*

Copyright (C) since 2006 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.collectiverun.bean;

import java.io.Serializable;

import javax.xml.bind.annotation.XmlType;

/**
 * Hinemosの一括制御履歴フィルタ情報を格納するクラス。<BR>
 * DTOクラスとしてマネージャ、クライアント間の通信で利用する。
 *
 */
@XmlType(namespace = "http://collectiverun.ws.clustercontrol.com")
public class HistoryFilterInfo implements Serializable {

	private static final long serialVersionUID = -6770508940565998424L;
	private Long startFromDate = null;	//開始日時（自）
	private Long startToDate = null;	//開始日時（至）
	private Long endFromDate = null;	//終了日時（自）
	private Long endToDate = null;		//終了日時（至）
	private String type = null;			//管理種別
	private String status = null;		//状態
	private Long startDate = null;		//開始日時
	private Long endDate = null;		//終了日時

	public void setStartFromDate(Long startFromDate) {
		this.startFromDate = startFromDate;
	}
	public Long getStartFromDate() {
		return startFromDate;
	}
	public void setStartToDate(Long startToDate) {
		this.startToDate = startToDate;
	}
	public Long getStartToDate() {
		return startToDate;
	}
	public void setEndFromDate(Long endFromDate) {
		this.endFromDate = endFromDate;
	}
	public Long getEndFromDate() {
		return endFromDate;
	}
	public void setEndToDate(Long endToDate) {
		this.endToDate = endToDate;
	}
	public Long getEndToDate() {
		return endToDate;
	}
	public void setType(String type) {
		this.type = type;
	}
	public String getType() {
		return type;
	}
	public void setStatus(String status) {
		this.status = status;
	}
	public String getStatus() {
		return status;
	}
	public void setStartDate(Long startDate) {
		this.startDate = startDate;
	}
	public Long getStartDate() {
		return startDate;
	}
	public void setEndDate(Long endDate) {
		this.endDate = endDate;
	}
	public Long getEndDate() {
		return endDate;
	}

}
