/*

Copyright (C) 2006 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.collectiverun.bean;

import javax.xml.bind.annotation.XmlType;


/**
 * 一括制御のパラメータ（選択肢）情報を保持するクラスです。<BR>
 * 一括制御[作成・変更]ダイアログから設定します。<BR>
 * 
 * 
 * @version 2.1.0
 * @since 2.1.0
 */
@XmlType(namespace = "http://collectiverun.ws.clustercontrol.com")
public class ParameterSelectInfo extends ItemInfo {
	private static final long serialVersionUID = 4810831880563808693L;

	/** パラメータID */
	private String id;

	/** 値 */
	private String value;

	/**
	 * @return
	 */
	public String getId() {
		return id;
	}

	/**
	 * @param id
	 */
	public void setId(String id) {
		this.id = id;
	}

	/**
	 * @return
	 */
	public String getValue() {
		return value;
	}

	/**
	 * @param value
	 */
	public void setValue(String value) {
		this.value = value;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#clone()
	 * @since 2.1.0
	 */
	@Override
	public Object clone() {
		ParameterSelectInfo clone = (ParameterSelectInfo)super.clone();

		clone.setId(this.getId());
		clone.setValue(this.getValue());

		return clone;
	}
}