package com.clustercontrol.jobmanagement.model;

import java.io.Serializable;
import java.util.Arrays;

import javax.persistence.*;

/**
 * The primary key class for the cc_job_notice_info database table.
 * 
 */
@Embeddable
public class JobNoticeInfoEntityPK implements Serializable {
	//default serial version id, required for serializable classes.
	private static final long serialVersionUID = 1L;
	private String sessionId;
	private String jobunitId;
	private String jobId;
	private Integer noticeType;

	public JobNoticeInfoEntityPK() {
	}

	public JobNoticeInfoEntityPK(String sessionId, String jobunitId, String jobId, Integer noticeType) {
		this.setSessionId(sessionId);
		this.setJobunitId(jobunitId);
		this.setJobId(jobId);
		this.setNoticeType(noticeType);
	}

	@Column(name="session_id")
	public String getSessionId() {
		return this.sessionId;
	}
	public void setSessionId(String sessionId) {
		this.sessionId = sessionId;
	}

	@Column(name="jobunit_id")
	public String getJobunitId() {
		return this.jobunitId;
	}
	public void setJobunitId(String jobunitId) {
		this.jobunitId = jobunitId;
	}

	@Column(name="job_id")
	public String getJobId() {
		return this.jobId;
	}
	public void setJobId(String jobId) {
		this.jobId = jobId;
	}

	@Column(name="notice_type")
	public Integer getNoticeType() {
		return this.noticeType;
	}
	public void setNoticeType(Integer noticeType) {
		this.noticeType = noticeType;
	}

	@Override
	public boolean equals(Object other) {
		if (this == other) {
			return true;
		}
		if (!(other instanceof JobNoticeInfoEntityPK)) {
			return false;
		}
		JobNoticeInfoEntityPK castOther = (JobNoticeInfoEntityPK)other;
		return
				this.sessionId.equals(castOther.sessionId)
				&& this.jobunitId.equals(castOther.jobunitId)
				&& this.jobId.equals(castOther.jobId)
				&& this.noticeType.equals(castOther.noticeType);
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int hash = 17;
		hash = hash * prime + this.sessionId.hashCode();
		hash = hash * prime + this.jobunitId.hashCode();
		hash = hash * prime + this.jobId.hashCode();
		hash = hash * prime + this.noticeType.hashCode();

		return hash;
	}

	@Override
	public String toString() {
		String[] names = {
				"sessionId",
				"jobunitId",
				"jobId",
				"noticeType"
		};
		String noticeTypeStr = null;
		if (noticeType != null) {
			noticeTypeStr = noticeType.toString();
		}
		String[] values = {
				this.sessionId,
				this.jobunitId,
				this.jobId,
				noticeTypeStr
		};
		return Arrays.toString(names) + " = " + Arrays.toString(values);
	}
}