package com.clustercontrol.notify.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import javax.persistence.*;

import com.clustercontrol.commons.util.JpaTransactionManager;


/**
 * The persistent class for the cc_notify_event_info database table.
 * 
 */
@Entity
@Table(name="cc_notify_event_info")
@Cacheable(true)
public class NotifyEventInfoEntity implements Serializable {
	private static final long serialVersionUID = 1L;
	private NotifyEventInfoEntityPK id;
	private Integer eventNormalFlg;
	private Integer eventNormalState;
	private NotifyInfoEntity notifyInfoEntity;

	@Deprecated
	public NotifyEventInfoEntity() {
	}

	public NotifyEventInfoEntity(NotifyEventInfoEntityPK pk,
			NotifyInfoEntity notifyInfoEntity) {
		this.setId(pk);
		EntityManager em = new JpaTransactionManager().getEntityManager();
		em.persist(this);
		this.relateToNotifyInfoEntity(notifyInfoEntity);
	}

	public NotifyEventInfoEntity(String notifyId, Integer priority,
			NotifyInfoEntity notifyInfoEntity) {
		this(new NotifyEventInfoEntityPK(notifyId, priority), notifyInfoEntity);
	}


	@EmbeddedId
	public NotifyEventInfoEntityPK getId() {
		return this.id;
	}

	public void setId(NotifyEventInfoEntityPK id) {
		this.id = id;
	}


	@Column(name="event_normal_flg")
	public Integer getEventNormalFlg() {
		return this.eventNormalFlg;
	}

	public void setEventNormalFlg(Integer eventNormalFlg) {
		this.eventNormalFlg = eventNormalFlg;
	}


	@Column(name="event_normal_state")
	public Integer getEventNormalState() {
		return this.eventNormalState;
	}

	public void setEventNormalState(Integer eventNormalState) {
		this.eventNormalState = eventNormalState;
	}


	//bi-directional many-to-one association to NotifyInfoEntity
	@ManyToOne(fetch=FetchType.LAZY)
	@JoinColumn(name="notify_id", insertable=false, updatable=false)
	public NotifyInfoEntity getNotifyInfoEntity() {
		return this.notifyInfoEntity;
	}

	@Deprecated
	public void setNotifyInfoEntity(NotifyInfoEntity notifyInfoEntity) {
		this.notifyInfoEntity = notifyInfoEntity;
	}

	/**
	 * NotifyInfoEntityオブジェクト参照設定<BR>
	 * 
	 * NotifyInfoEntity設定時はSetterに代わりこちらを使用すること。
	 * 
	 * JPAの仕様(JSR 220)では、データ更新に伴うrelationshipの管理はユーザに委ねられており、
	 * INSERTやDELETE時に、そのオブジェクトに対する参照をメンテナンスする処理を実装する。
	 * 
	 * JSR 220 3.2.3 Synchronization to the Database
	 * 
	 * Bidirectional relationships between managed entities will be persisted
	 * based on references held by the owning side of the relationship.
	 * It is the developer’s responsibility to keep the in-memory references
	 * held on the owning side and those held on the inverse side consistent
	 * with each other when they change.
	 */
	public void relateToNotifyInfoEntity(NotifyInfoEntity notifyInfoEntity) {
		this.setNotifyInfoEntity(notifyInfoEntity);
		if (notifyInfoEntity != null) {
			List<NotifyEventInfoEntity> list = notifyInfoEntity.getNotifyEventInfoEntities();
			if (list == null) {
				list = new ArrayList<NotifyEventInfoEntity>();
			} else {
				for(NotifyEventInfoEntity entity : list){
					if (entity.getId().equals(this.getId())) {
						return;
					}
				}
			}
			list.add(this);
			notifyInfoEntity.setNotifyEventInfoEntities(list);
		}
	}


	/**
	 * 削除前処理<BR>
	 * 
	 * JPAの仕様(JSR 220)では、データ更新に伴うrelationshipの管理はユーザに委ねられており、
	 * INSERTやDELETE時に、そのオブジェクトに対する参照をメンテナンスする処理を実装する。
	 * 
	 * JSR 220 3.2.3 Synchronization to the Database
	 * 
	 * Bidirectional relationships between managed entities will be persisted
	 * based on references held by the owning side of the relationship.
	 * It is the developer’s responsibility to keep the in-memory references
	 * held on the owning side and those held on the inverse side consistent
	 * with each other when they change.
	 */
	public void unchain() {

		// NotifyInfoEntity
		if (this.notifyInfoEntity != null) {
			List<NotifyEventInfoEntity> list = this.notifyInfoEntity.getNotifyEventInfoEntities();
			if (list != null) {
				Iterator<NotifyEventInfoEntity> iter = list.iterator();
				while(iter.hasNext()) {
					NotifyEventInfoEntity entity = iter.next();
					if (entity.getId().equals(this.getId())){
						iter.remove();
						break;
					}
				}
			}
		}
	}

}