/*

Copyright (C) 2006 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.repository.util;

import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Properties;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * SNMPでノードの情報を埋める際の定義情報のクラス<BR>
 *
 * @version 2.3.0
 * @since 2.1.2
 */
public class SearchNodeProperties {
	private static Log m_log = LogFactory.getLog( SearchNodeProperties.class );

	private static SearchNodeProperties m_instance = null;
	private static Properties properties;

	private static final String DEFAULT_TIMEOUT="5000";
	private static final String DEFAULT_RETRY="1";
	private static final String DEFAULT_OID_NAME      =".1.3.6.1.2.1.1.5.0";
	private static final String DEFAULT_OID_DESCR     =".1.3.6.1.2.1.1.1.0";
	private static final String DEFAULT_OID_CONTACT   =".1.3.6.1.2.1.1.4.0";
	private static final String DEFAULT_OID_CPU_INDEX = ".1.3.6.1.2.1.25.3.3.1.2";
	private static final String DEFAULT_OID_DISK_INDEX=".1.3.6.1.4.1.2021.13.15.1.1.1";
	private static final String DEFAULT_OID_DISK_NAME =".1.3.6.1.4.1.2021.13.15.1.1.2";
	private static final String DEFAULT_OID_DISK_ION_READ = ".1.3.6.1.4.1.2021.13.15.1.1.3";
	private static final String DEFAULT_OID_DISK_ION_WRITE = ".1.3.6.1.4.1.2021.13.15.1.1.4";
	private static final String DEFAULT_OID_DISK_IO_READ = ".1.3.6.1.4.1.2021.13.15.1.1.5";
	private static final String DEFAULT_OID_DISK_IO_WRITE = ".1.3.6.1.4.1.2021.13.15.1.1.6";
	private static final String DEFAULT_OID_NIC_INDEX =".1.3.6.1.2.1.2.2.1.1";
	private static final String DEFAULT_OID_NIC_NAME  =".1.3.6.1.2.1.2.2.1.2";
	public static final String DEFAULT_OID_NIC_MAC_ADDRESS = ".1.3.6.1.2.1.2.2.1.6";
	private static final String DEFAULT_OID_NIC_IP_ADDRESSV4 = ".1.3.6.1.2.1.4.34.1.3.1.4";
	private static final String DEFAULT_OID_NIC_IP_ADDRESSV6 = ".1.3.6.1.2.1.4.34.1.3.2.16";
	private static final String DEFAULT_OID_NIC_IP_ADDRESSV4_TYPE = ".1.3.6.1.2.1.4.34.1.4.1.4";
	private static final String DEFAULT_OID_NIC_IN_OCTET = ".1.3.6.1.2.1.2.2.1.10";
	private static final String DEFAULT_OID_NIC_IN_UCAST_PKTS = ".1.3.6.1.2.1.2.2.1.11";
	private static final String DEFAULT_OID_NIC_IN_ERROR = ".1.3.6.1.2.1.2.2.1.14";
	private static final String DEFAULT_OID_NIC_OUT_OCTET = ".1.3.6.1.2.1.2.2.1.16";
	private static final String DEFAULT_OID_NIC_OUT_UCAST_PKTS = ".1.3.6.1.2.1.2.2.1.17";
	private static final String DEFAULT_OID_NIC_OUT_ERROR = ".1.3.6.1.2.1.2.2.1.20";
	private static final String DEFAULT_OID_FILESYSTEM_INDEX = ".1.3.6.1.2.1.25.2.3.1.1";
	private static final String DEFAULT_OID_FILESYSTEM_TYPE = ".1.3.6.1.2.1.25.2.3.1.2";
	public static final String DEFAULT_OID_FILESYSTEM_NAME  = ".1.3.6.1.2.1.25.2.3.1.3";

	private static final String TIMEOUT_KEY       = "common.repository.snmp.timeout";
	private static final String RETRY_KEY         = "common.repository.snmp.retry";
	private static final String OID_NAME_KEY      = "common.repository.snmp.oid.name";
	private static final String OID_DESCR_KEY     = "common.repository.snmp.oid.descr";
	private static final String OID_CONTACT_KEY   = "common.repository.snmp.oid.contact";
	private static final String OID_CPU_INDEX_KEY = "common.repository.snmp.oid.cpu.index";
	private static final String OID_DISK_INDEX_KEY= "common.repository.snmp.oid.disk.index";
	private static final String OID_DISK_NAME_KEY = "common.repository.snmp.oid.disk.name";
	private static final String OID_DISK_ION_READ_KEY = "common.repository.snmp.oid.disk.ion.read";
	private static final String OID_DISK_ION_WRITE_KEY = "common.repository.snmp.oid.disk.ion.write";
	private static final String OID_DISK_IO_READ_KEY = "common.repository.snmp.oid.disk.io.read";
	private static final String OID_DISK_IO_WRITE_KEY = "common.repository.snmp.oid.disk.io.write";
	private static final String OID_NIC_INDEX_KEY = "common.repository.snmp.oid.nic.index";
	private static final String OID_NIC_NAME_KEY  = "common.repository.snmp.oid.nic.name";
	private static final String OID_NIC_MAC_ADDRESS_KEY  = "common.repository.snmp.oid.nic.mac.address";
	private static final String OID_NIC_IP_ADDRESSV4_KEY = "common.repository.snmp.oid.nic.ipv4.address";
	private static final String OID_NIC_IP_ADDRESSV6_KEY = "common.repository.snmp.oid.nic.ipv6.address";
	private static final String OID_NIC_IN_UCAST_PKTS_KEY = "common.repository.snmp.oid.nic.in.ucast";
	private static final String OID_NIC_OUT_UCAST_PKTS_KEY = "common.repository.snmp.oid.nic.out.ucast";
	private static final String OID_NIC_IN_ERROR_KEY = "common.repository.snmp.oid.nic.in.error";
	private static final String OID_NIC_OUT_ERROR_KEY = "common.repository.snmp.oid.nic.out.error";
	private static final String OID_NIC_IN_OCTET_KEY = "common.repository.snmp.oid.nic.in.octet";
	private static final String OID_NIC_OUT_OCTET_KEY = "common.repository.snmp.oid.nic.out.octet";
	private static final String OID_FILESYSTEM_INDEX_KEY = "common.repository.snmp.oid.filesystem.index";
	private static final String OID_FILESYSTEM_TYPE_KEY = "common.repository.snmp.oid.filesystem.type";
	private static final String OID_FILESYSTEM_NAME_KEY  = "common.repository.snmp.oid.filesystem.name";

	/**
	 * プロパティのデータセットをシングルトンで返します。
	 * @version 2.3.0
	 * @since 2.1.2
	 * 
	 * @return ConnectionManager ���ͥ������ޥ͡�����
	 */
	public static SearchNodeProperties getProperties() {
		if (m_instance==null) {
			m_instance = new SearchNodeProperties();
		}
		return m_instance;
	}

	/**
	 * コンストラクタ
	 * @version 2.1.2
	 * @since 2.1.2
	 */
	private SearchNodeProperties() {
		this.setValue();
	}

	/**
	 * SNMPポーリングに必要な設定値をプロパティファイルから読み込みます。
	 * 
	 * @version 2.0.0
	 * @since 2.0.0
	 */
	private void setValue() {

		properties = new Properties();

		try {
			String etcdir = System.getProperty("hinemos.manager.etc.dir");
			String propertyFile = etcdir + File.separator + "hinemos.properties";
			properties.load(new FileInputStream(propertyFile));
		} catch (Exception e) {
			m_log.warn("setValue(): "
					+ e.getClass().getSimpleName() + ", " + e.getMessage(), e);
		}
	}

	public int getTimeOut(){
		int ret = Integer.parseInt(properties.getProperty(TIMEOUT_KEY,DEFAULT_TIMEOUT));
		return ret;
	}

	public int getRetry(){
		int ret = Integer.parseInt(properties.getProperty(RETRY_KEY,DEFAULT_RETRY));
		return ret;
	}

	public ArrayList<String> getOidList(){
		ArrayList<String> ret = new ArrayList<String>();

		ret.add(properties.getProperty(OID_NAME_KEY,DEFAULT_OID_NAME));
		ret.add(properties.getProperty(OID_DESCR_KEY,DEFAULT_OID_DESCR));
		ret.add(properties.getProperty(OID_CONTACT_KEY,DEFAULT_OID_CONTACT));
		ret.add(properties.getProperty(OID_CPU_INDEX_KEY,DEFAULT_OID_CPU_INDEX));
		ret.add(properties.getProperty(OID_DISK_INDEX_KEY,DEFAULT_OID_DISK_INDEX));
		ret.add(properties.getProperty(OID_DISK_NAME_KEY,DEFAULT_OID_DISK_NAME));
		ret.add(properties.getProperty(OID_DISK_ION_READ_KEY,DEFAULT_OID_DISK_ION_READ));
		ret.add(properties.getProperty(OID_DISK_ION_WRITE_KEY,DEFAULT_OID_DISK_ION_WRITE));
		ret.add(properties.getProperty(OID_DISK_IO_READ_KEY,DEFAULT_OID_DISK_IO_READ));
		ret.add(properties.getProperty(OID_DISK_IO_WRITE_KEY,DEFAULT_OID_DISK_IO_WRITE));
		ret.add(properties.getProperty(OID_NIC_INDEX_KEY,DEFAULT_OID_NIC_INDEX));
		ret.add(properties.getProperty(OID_NIC_NAME_KEY,DEFAULT_OID_NIC_NAME));
		ret.add(properties.getProperty(OID_NIC_MAC_ADDRESS_KEY,DEFAULT_OID_NIC_MAC_ADDRESS));
		ret.add(properties.getProperty(OID_NIC_IP_ADDRESSV4_KEY,DEFAULT_OID_NIC_IP_ADDRESSV4));
		ret.add(properties.getProperty(OID_NIC_IP_ADDRESSV6_KEY,DEFAULT_OID_NIC_IP_ADDRESSV6));
		ret.add(properties.getProperty(OID_NIC_IP_ADDRESSV4_KEY,DEFAULT_OID_NIC_IP_ADDRESSV4_TYPE));
		ret.add(properties.getProperty(OID_NIC_IP_ADDRESSV6_KEY,DEFAULT_OID_NIC_IP_ADDRESSV4_TYPE));
		ret.add(properties.getProperty(OID_NIC_IN_OCTET_KEY,DEFAULT_OID_NIC_IN_OCTET));
		ret.add(properties.getProperty(OID_NIC_IN_UCAST_PKTS_KEY,DEFAULT_OID_NIC_IN_UCAST_PKTS));
		ret.add(properties.getProperty(OID_NIC_IN_ERROR_KEY,DEFAULT_OID_NIC_IN_ERROR));
		ret.add(properties.getProperty(OID_NIC_OUT_OCTET_KEY,DEFAULT_OID_NIC_OUT_OCTET));
		ret.add(properties.getProperty(OID_NIC_OUT_UCAST_PKTS_KEY,DEFAULT_OID_NIC_OUT_UCAST_PKTS));
		ret.add(properties.getProperty(OID_NIC_OUT_ERROR_KEY,DEFAULT_OID_NIC_OUT_ERROR));
		ret.add(properties.getProperty(OID_FILESYSTEM_INDEX_KEY,DEFAULT_OID_FILESYSTEM_INDEX ));
		ret.add(properties.getProperty(OID_FILESYSTEM_TYPE_KEY ,DEFAULT_OID_FILESYSTEM_TYPE));
		ret.add(properties.getProperty(OID_FILESYSTEM_NAME_KEY,DEFAULT_OID_FILESYSTEM_NAME));

		return ret;

	}

}
