/*

 Copyright (C) 2006 NTT DATA Corporation

 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation, version 2.

 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.snmptrap.bean;

import javax.xml.bind.annotation.XmlType;

import com.clustercontrol.monitor.run.bean.MonitorCheckInfo;

/**
 * SNMPTRAP監視のチェック条件のBean<BR>
 *
 * @version 4.0.0
 * @since 4.0.0
 */
@XmlType(namespace = "http://monitor.ws.clustercontrol.com")
public class TrapCheckInfo extends MonitorCheckInfo {

	private static final long serialVersionUID = -6268421338333854249L;

	/** コミュニティ名 */
	private String communityName;
	/** 監視チェックモード */
	private Integer checkMode = new Integer(0);
	/** コミュニティ名チェックの有無 */
	private Integer communityCheck = new Integer(0);
	/** 文字コード変換の有無 */
	private Integer charsetConvert = new Integer(0);
	/** 文字コード/文字セット名 */
	private String charsetName;

	/**
	 * デフォルトコンストラクタ
	 */
	public TrapCheckInfo() {
	}



	/**
	 * コンストラクタ
	 * @param communityName
	 * @param checkMode
	 * @param communityCheck
	 * @param charsetConvert
	 * @param charsetName
	 */
	public TrapCheckInfo(String communityName, Integer checkMode,
			Integer communityCheck, Integer charsetConvert, String charsetName) {
		super();
		this.communityName = communityName;
		this.checkMode = checkMode;
		this.communityCheck = communityCheck;
		this.charsetConvert = charsetConvert;
		this.charsetName = charsetName;
	}



	public String getCommunityName() {
		return communityName;
	}

	public void setCommunityName(String communityName) {
		this.communityName = communityName;
	}

	public Integer getCheckMode() {
		return checkMode;
	}

	public void setCheckMode(Integer checkMode) {
		this.checkMode = checkMode;
	}

	public Integer getCommunityCheck() {
		return communityCheck;
	}

	public void setCommunityCheck(Integer communityCheck) {
		this.communityCheck = communityCheck;
	}

	public Integer getCharsetConvert() {
		return charsetConvert;
	}

	public void setCharsetConvert(Integer charsetConvert) {
		this.charsetConvert = charsetConvert;
	}

	public String getCharsetName() {
		return charsetName;
	}

	public void setCharsetName(String charsetName) {
		this.charsetName = charsetName;
	}

}
