/*

Copyright (C) 2008 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.snmptrap.factory;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.commons.scheduler.TriggerSchedulerException;
import com.clustercontrol.fault.HinemosUnknown;
import com.clustercontrol.fault.InvalidRole;
import com.clustercontrol.fault.MonitorNotFound;
import com.clustercontrol.monitor.run.factory.ModifyMonitorTrapValueType;
import com.clustercontrol.monitor.run.model.MonitorInfoEntity;
import com.clustercontrol.plugin.impl.SchedulerPlugin.TriggerType;
import com.clustercontrol.snmptrap.bean.TrapCheckInfo;
import com.clustercontrol.snmptrap.model.MonitorTrapInfoEntity;
import com.clustercontrol.snmptrap.util.CharsetUtil;
import com.clustercontrol.snmptrap.util.QueryUtil;

/**
 * SNMPTRAP監視情報を変更するクラス<BR>
 *
 * @version 4.0.0
 * @since 4.0.0
 */
public class ModifyMonitorTrap extends ModifyMonitorTrapValueType {

	private static Log m_log = LogFactory.getLog( ModifyMonitorTrap.class );

	/**
	 * SNMPトラップ監視設定の変更(変更時に文字コードをチェック)
	 */
	@Override
	protected boolean modifyMonitorInfo(String user) throws MonitorNotFound, TriggerSchedulerException, HinemosUnknown, InvalidRole {
		CharsetUtil.checkCharset(m_monitorInfo);

		return super.modifyMonitorInfo(user);
	}

	@Override
	protected boolean modifyCheckInfo() throws MonitorNotFound, InvalidRole {

		m_log.debug("modifyCheckInfo() : start");

		MonitorInfoEntity monitorEntity
		= com.clustercontrol.monitor.run.util.QueryUtil.getMonitorInfoPK(m_monitorInfo.getMonitorId());

		// SNMPTRAP監視情報を取得
		MonitorTrapInfoEntity entity = QueryUtil.getMonitorTrapInfoPK(m_monitorInfo.getMonitorId());

		TrapCheckInfo trap = m_monitorInfo.getTrapCheckInfo();
		if(m_log.isDebugEnabled()){
			m_log.debug("modifyCheckInfo() : " +
					" MonitorId = " + trap.getMonitorId() +
					",CommunityName = " + trap.getCommunityName() +
					",CheckMode = " + trap.getCheckMode() +
					",CommunityCheck = " + trap.getCommunityCheck() +
					",CharsetConvert = " + trap.getCharsetConvert() +
					",CharsetName = " + trap.getCharsetName());
		}
		entity.setCommunityName(trap.getCommunityName());
		entity.setCheckMode(trap.getCheckMode());
		entity.setCommunityCheck(trap.getCommunityCheck());
		entity.setCharsetConvert(trap.getCharsetConvert());
		entity.setCharsetName(trap.getCharsetName());
		monitorEntity.setMonitorTrapInfoEntity(entity);

		m_log.debug("modifyCheckInfo() : end");
		return true;
	}

	/**
	 * スケジュール実行の遅延時間を返します。
	 */
	@Override
	protected int getDelayTime() {
		return 0;
	}

	/**
	 * スケジュール実行種別を返します。
	 */
	@Override
	protected TriggerType getTriggerType() {
		return TriggerType.NONE;
	}
}
