/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.swt.layout.grouplayout;

import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wb.swt.layout.grouplayout.LayoutStyle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class WindowsLayoutStyle
extends LayoutStyle {
    protected static final int HORIZONTAL_DIALOG_UNIT_PER_CHAR = 4;
    protected static final int VERTICAL_DIALOG_UNITS_PER_CHAR = 8;
    protected FontMetrics m_fontMetrics;

    WindowsLayoutStyle() {
    }

    @Override
    public int getPreferredGap(Class<?> source, int sourceStyle, Class<?> target, int targetStyle, int type, int position) {
        super.getPreferredGap(source, sourceStyle, target, targetStyle, type, position);
        if (type == 3) {
            if (position == 16384 || position == 131072) {
                return 10;
            }
            type = 0;
        }
        if (type == 1) {
            return this.dlusToPixels(7, position);
        }
        boolean sourceLabel = source.isAssignableFrom(Label.class);
        boolean targetLabel = target.isAssignableFrom(Label.class);
        if ((sourceLabel && !targetLabel || targetLabel && !sourceLabel) && (position == 16384 || position == 131072)) {
            return this.dlusToPixels(3, position);
        }
        return this.dlusToPixels(4, position);
    }

    @Override
    public int getContainerGap(Class<?> controlClass, int controlStyle, int position) {
        super.getContainerGap(controlClass, controlStyle, position);
        return this.dlusToPixels(7, position);
    }

    private int dlusToPixels(int dlus, int direction) {
        if (direction == 16384 || direction == 131072) {
            return (this.getDefaultFontMetrics().getAverageCharWidth() * dlus + 2) / 4;
        }
        if (direction == 128 || direction == 1024) {
            return (this.getDefaultFontMetrics().getHeight() * dlus + 4) / 8;
        }
        throw new IllegalArgumentException("direction = " + direction);
    }

    protected FontMetrics getDefaultFontMetrics() {
        if (this.m_fontMetrics == null) {
            Display currentDisplay = Display.getCurrent();
            Shell shell = new Shell();
            Font font = currentDisplay == null ? new Font(null, shell.getFont().getFontData()) : new Font((Device)currentDisplay, currentDisplay.getSystemFont().getFontData());
            GC gc = new GC((Drawable)shell);
            gc.setFont(font);
            this.m_fontMetrics = gc.getFontMetrics();
            gc.dispose();
            shell.dispose();
            font.dispose();
        }
        return this.m_fontMetrics;
    }
}

