package com.clustercontrol.xcloud.model.cloud;

import java.util.ArrayList;
import java.util.List;

public class Network extends Resource implements INetwork {
	protected String id;
	protected String name;
	protected String networkType;
	protected List<String> attachedInstances = new ArrayList<>();

	public Network() {
	}

	@Override
	public String getId() {return id;}
	public void setId(String id) {this.id = id;}

	@Override
	public String getName() {return name;}
	public void setName(String name) {internalSetProperty(INetwork.p.name, name);}

	@Override
	public String getNetworkType() {return networkType;}
	public void setNetworkType(String networkType) {internalSetProperty(INetwork.p.networkType, networkType);}

	@Override
	public ComputeResources getCloudCompute() {return (ComputeResources)getOwner();}

	public static Network convert(com.clustercontrol.ws.xcloud.Network source) {
		Network network = new Network();
		network.update(source);
		return network;
	}
	
	public boolean equalValues(com.clustercontrol.ws.xcloud.Network source) {
		return getId().equals(source.getId());
	}

	protected void update(com.clustercontrol.ws.xcloud.Network source) {
		setId(source.getId());
		setName(source.getName());
		setNetworkType(source.getResourceTypeAsPlatform());
		
		getAttachedInstances().clear();
		getAttachedInstances().addAll(source.getAttachedInstances());
		
		updateExtendedProperties(source.getExtendedProperties());
	}

	@Override
	public Location getLocation() {
		return getCloudCompute().getLocation();
	}

	@Override
	public List<String> getAttachedInstances() {
		return attachedInstances;
	}
}
