package com.clustercontrol.xcloud.plugin.tester;

import java.util.regex.Pattern;

import com.clustercontrol.xcloud.model.cloud.IInstance;

public class InstanceTester extends CloudOptionPropertyTester {

	@Override
	protected Boolean resourceTest(Object receiver, String property, Object[] args, Object expectedValue) {
		IInstance instance = (IInstance)receiver;
		switch(property) {
		case "facilityId":
			String facilityId = instance.getFacilityId();
			if (facilityId == null) {
				return expectedValue == null;
			} else {
				return expectedValue != null ? Pattern.matches((String)expectedValue, facilityId): false;
			}
		case "status":
			String status = instance.getStatus();
			if (status == null) {
				return expectedValue == null;
			} else {
				return expectedValue != null ? Pattern.matches((String)expectedValue, status): false;
			}
		}
		return null;
	}
}
