package com.clustercontrol.xcloud.ui.handlers;

import java.text.MessageFormat;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.ui.handlers.HandlerUtil;

import com.clustercontrol.ws.xcloud.CloudEndpoint;
import com.clustercontrol.xcloud.extensions.CloudOptionExtension;
import com.clustercontrol.xcloud.model.cloud.ICloudScope;
import com.clustercontrol.xcloud.plugin.CloudOptionSourceProvider;

public class PowerOnInstanceGroupJobHandler extends AbstaractCloudOptionGroupJobHandler {
	protected ICloudScope cloudScope;

	@Override
	protected void setup(ExecutionEvent event) {
		cloudScope = (ICloudScope)HandlerUtil.getVariable(event, CloudOptionSourceProvider.ActiveCloudScope);
	}
	@Override
	protected ICloudScope getCloudScope() {
		return cloudScope;
	}
	@Override
	protected String getCommand(CloudEndpoint endpoint, String facilityId) throws Exception {
		return endpoint.makePowerOnInstancesCommandUsingFacility(cloudScope.getId(), facilityId);
	}
	@Override
	protected String getJobName(String facilityId) {
		return getJobId(facilityId);
	}
	@Override
	protected String getJobId(String facilityId) {
		return String.format("%s_%s_i-poweron", cloudScope.getId(), facilityId);
	}
	@Override
	protected String getMethodName() {
		return "makePowerOnInstancesCommandUsingFacility";
	}
	@Override
	protected String getWizardTitle() {
		return MessageFormat.format(dlgComputePowerOn, CloudOptionExtension.getOptions().get(cloudScope.getCloudPlatform().getId()));
	}
}