package com.clustercontrol.xcloud.model.cloud;

import com.clustercontrol.xcloud.model.base.Element;

public class BackupedDataEntry extends Element implements IBackupedDataEntry {
	private String name;
	private String value;

	@Override
	public String getName() {
		return name;
	}
	public void setName(String name) {
		internalSetProperty(p.name, name);
	}

	@Override
	public String getValue() {
		return value;
	}
	public void setValue(String value) {
		internalSetProperty(p.value, value);
	}
	
	protected void update(com.clustercontrol.ws.xcloud.BackupedDataEntry source) {
		setName(source.getName());
		setValue(source.getValue());
	}
	
	public static BackupedDataEntry convert(com.clustercontrol.ws.xcloud.BackupedDataEntry source) {
		BackupedDataEntry storage = new BackupedDataEntry();
		storage.update(source);
		return storage;
	}
}
