/*
Copyright (C) 2015 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.xcloud.model.repository;

import java.util.ArrayList;
import java.util.List;

import com.clustercontrol.xcloud.model.cloud.HinemosManager;

public class Scope extends Facility implements IScope {
	protected Scope parent;
	protected List<Facility> facilities = new ArrayList<Facility>();

	public Scope() {
	}
	
	@Override
	public Scope getParent() {
		return parent;
	}
	
	public void setParent(Scope parent) {
		this.parent = parent;
	}

	@Override
	public Facility[] getFacilities() {
		return facilities.toArray(new Facility[facilities.size()]);
	}

	public void addFacility(Facility child) {
		if (!facilities.contains(child)) {
			if (child instanceof Scope) {
				((Scope)child).setParent(this);
			} else if (child instanceof Node) {
				((Node)child).setParent(this);
			}
			internalAddProperty(IScope.p.facilities, child);
		}
	}
	
	public void removeFacility(Facility child) {
		if (facilities.contains(child)) {
			if (child instanceof Scope) {
				((Scope)child).setParent(null);
			} else if (child instanceof Node) {
				((Node)child).setParent(null);
			}
			internalRemoveProperty(IScope.p.facilities, child);
		}
	}

	@Override
	public HinemosManager getHinemosManager() {
		return getCloudRepository().getHinemosManager();
	}
	
	public static Scope convert(com.clustercontrol.ws.xcloud.HScope source) {
		Scope scope = new Scope();
		scope.update(source);
		return scope;
	}
	
	@Override
	public CloudRepository getCloudRepository() {
		return parent.getCloudRepository();
	}

	@Override
	public CloudScopeScope getCloudScopeScope() {
		return parent.getCloudScopeScope();
	}

	@Override
	public LocationScope getLocationScope() {
		return parent.getLocationScope();
	}
	
	@Override
	public void visit(IVisitor visitor) {
		visitor.visit(this);
	}
	@Override
	public <T> T transform(ITransformer<T> transformor) {
		return transformor.transform(this);
	}
}
