/*

Copyright (C) 2015 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.xcloud.ui.dialogs;

import java.lang.reflect.Field;
import java.util.HashMap;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

import com.clustercontrol.accesscontrol.dialog.ObjectPrivilegeListDialog;
import com.clustercontrol.accesscontrol.util.ObjectPrivilegeBean;
import com.clustercontrol.util.Messages;

/**
 * オブジェクト権限設定一覧ダイアログクラス<BR>
 * 
 * @version 4.1.0
 * @since 4.1.0
 */
public class BillingAlarmObjectPrivilegeListDialog extends ObjectPrivilegeListDialog {
	public static final long serialVersionUID = 1L;
	private String objectId;
	private String ownerRoleId;
	private String managerName;

	public BillingAlarmObjectPrivilegeListDialog(Shell parent, String managerName, String objectId, String ownerRoleId) {
		super(parent, managerName, objectId, "CLOUD_BILLING_ALARM", ownerRoleId);
		this.objectId = objectId;
		this.ownerRoleId = ownerRoleId;
		this.managerName = managerName;
	}

	/**
	 * 既存のボタンに加え、編集ボタンを追加します。
	 * 
	 * @param parent
	 *            ボタンバーコンポジット
	 */
	@Override
	protected void createButtonsForButtonBar(Composite parent) {
		// 編集ボタン
		this.createButton(parent, IDialogConstants.OPEN_ID, Messages.getString("edit"), false);
		this.getButton(IDialogConstants.OPEN_ID).addSelectionListener(
				new SelectionAdapter() {
					@SuppressWarnings("unchecked")
					@Override
					public void widgetSelected(SelectionEvent e) {
						boolean accessible = false;
						Field f = null;
						HashMap<String, ObjectPrivilegeBean> objPrivMap;
						try {
							f = ObjectPrivilegeListDialog.class.getDeclaredField("m_objPrivMap");
							accessible = f.isAccessible();
							f.setAccessible(true);
							objPrivMap = (HashMap<String, ObjectPrivilegeBean>)f.get(BillingAlarmObjectPrivilegeListDialog.this);
						}
						catch (NoSuchFieldException | SecurityException | IllegalArgumentException | IllegalAccessException e1) {
							throw new IllegalStateException(e1);
						}
						finally {
							if (f != null) {
								f.setAccessible(accessible);
							}
						}
						
						BillingAlarmObjectPrivilegeEditDialog dialog =
								new BillingAlarmObjectPrivilegeEditDialog(getParentShell(), managerName,
										objectId, ownerRoleId, objPrivMap);
						dialog.open();

						// 編集した内容でアップデート
						update();
					}
				});

		// 閉じるボタン
		this.createButton(parent, IDialogConstants.CANCEL_ID, IDialogConstants.CLOSE_LABEL, false);	}
}
