/*
Copyright (C) 2015 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.xcloud.ui.dialogs;

import static com.clustercontrol.xcloud.common.CloudConstants.bundle_messages;

import java.util.ArrayList;
import java.util.List;

import org.apache.log4j.Logger;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.swt.SWTResourceManager;

import com.clustercontrol.ClusterControlPlugin;
import com.clustercontrol.bean.RequiredFieldColorConstant;
import com.clustercontrol.composite.RoleIdListComposite;
import com.clustercontrol.composite.RoleIdListComposite.Mode;
import com.clustercontrol.dialog.ScopeTreeDialog;
import com.clustercontrol.notify.composite.NotifyIdListComposite;
import com.clustercontrol.repository.FacilityPath;
import com.clustercontrol.repository.bean.FacilityConstant;
import com.clustercontrol.repository.util.RepositoryEndpointWrapper;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.notify.NotifyRelationInfo;
import com.clustercontrol.ws.repository.FacilityInfo;
import com.clustercontrol.ws.repository.FacilityTreeItem;
import com.clustercontrol.ws.repository.HinemosUnknown_Exception;
import com.clustercontrol.ws.repository.InvalidRole_Exception;
import com.clustercontrol.ws.repository.InvalidUserPass_Exception;
import com.clustercontrol.ws.xcloud.MonitorKind;
import com.clustercontrol.xcloud.platform.PlatformDependent;
import com.clustercontrol.xcloud.util.ControlUtil;

public class CreateBillingAlarmDialog extends Dialog {
	public static final long serialVersionUID = 1L;
	public interface DialogDataFactory {
		DialogData createDialogData();
	}

	public static interface DialogData {
		public String getAlarmId();
		public void setAlarmId(String value);
		public String getAlarmName();
		public void setAlarmName(String value);
		public String getDescription();
		public void setDescription(String value);
		public String getFacilityId();
		public void setFacilityId(String value);
		public MonitorKind getMonitorKind();
		public void setMonitorKind(MonitorKind value);
		public List<NotifyRelationInfo> getNotifyRelationInfos();
		public void setNotifyRelationInfos(List<NotifyRelationInfo> value);
		public Double getThresholdInfoLimit();
		public void setThresholdInfoLimit(Double value);
		public Double getThresholdWarnLimit();
		public void setThresholdWarnLimit(Double value);
		public Boolean getValidFlg();
		public void setValidFlg(Boolean value);
		public Boolean getCollectFlg();
		public void setCollectFlg(Boolean value);
		public String getOwnerRoleId();
		public void setOwnerRoleId(String value);
	}

	public static final String MONITOR_CLOUD_BILLING_ALARM = "CLOUD_BILLING_ALARM";
	public static final int TYPE_MONITOR_WINSERVICE = 400;
	public static final String STRING_MONITOR_CLOUD_BILLING_ALARM = bundle_messages.getString("word.billing_alarm");

	private String msgBillingAlarmInvalidLimit = bundle_messages.getString("message.billing_alarm_invalid_limit");

	protected Text txtAlarmId;
	protected Text txtAlarmName;
	protected Text txtThresholdInfoLimit;
	protected Text txtThresholdWarnLimit;
	protected Text txtDescription;
	protected Button btnValidFlg;
	
	protected DialogDataFactory factory;
	protected DialogData output;

	protected List<NotifyRelationInfo> notifyRelationInfoList;

	/** 通知情報 */
	protected NotifyIdListComposite notifyInfo = null;
	protected Combo cmbType;
	protected RoleIdListComposite cmbRole;
	protected Label lblFacilityId;

	protected String managerName;
	
	public void setDialogDataFactory(DialogDataFactory factory) {
		this.factory = factory;
	}
	
	public void setDialogData(DialogData data) {
		this.output = data;
	}
	
	/**
	 * Create the dialog.
	 * @param parentShell
	 * @wbp.parser.constructor
	 */
	public CreateBillingAlarmDialog(Shell parentShell, String managerName) {
		super(parentShell);
		setShellStyle(SWT.CLOSE | SWT.RESIZE | SWT.TITLE | SWT.APPLICATION_MODAL);
		this.managerName = managerName;
	}

	/**
	 * Create contents of the dialog.
	 * @param parent
	 */
	@Override
	protected Control createDialogArea(Composite parent) {
		Composite container = (Composite) super.createDialogArea(parent);
		GridLayout gl_container = new GridLayout(5, false);
		gl_container.marginHeight = 13;
		gl_container.marginWidth = 18;
		container.setLayout(gl_container);

		Group group_2 = new Group(container, SWT.NONE);
		group_2.setLayout(new GridLayout(4, false));
		group_2.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, false, 5, 1));
		group_2.setText(bundle_messages.getString("word.alarm"));

		Label lblAlarmId = new Label(group_2, SWT.NONE);
		lblAlarmId.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		lblAlarmId.setAlignment(SWT.RIGHT);
		lblAlarmId.setText(bundle_messages.getString("word.alarm_id") + bundle_messages.getString("caption.title_separator"));
		
				txtAlarmId = new Text(group_2, SWT.BORDER);
				txtAlarmId.addModifyListener(new ModifyListener() {
					public void modifyText(ModifyEvent e) {
						checkFinished();
					}
				});
				GridData gd_txtAlarmId = new GridData(SWT.FILL, SWT.CENTER, true, false, 3, 1);
				gd_txtAlarmId.widthHint = 378;
				txtAlarmId.setLayoutData(gd_txtAlarmId);

		Label lblAlarmName = new Label(group_2, SWT.NONE);
		lblAlarmName.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		lblAlarmName.setAlignment(SWT.RIGHT);
		lblAlarmName.setText(bundle_messages.getString("word.alarm_name") + bundle_messages.getString("caption.title_separator"));
				
						txtAlarmName = new Text(group_2, SWT.BORDER);
						txtAlarmName.addModifyListener(new ModifyListener() {
							public void modifyText(ModifyEvent e) {
								checkFinished();
							}
						});
						txtAlarmName.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 3, 1));

		Label lblDescription = new Label(group_2, SWT.NONE);
		lblDescription.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		lblDescription.setAlignment(SWT.RIGHT);
		lblDescription.setText(bundle_messages.getString("word.description") + bundle_messages.getString("caption.title_separator"));
				
						txtDescription = new Text(group_2, SWT.BORDER);
						txtDescription.addModifyListener(new ModifyListener() {
							public void modifyText(ModifyEvent e) {
								checkFinished();
							}
						});
						txtDescription.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 3, 1));

		Label lblRole = new Label(group_2, SWT.NONE);
		lblRole.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		lblRole.setText(bundle_messages.getString("word.owner_role_id") + bundle_messages.getString("caption.title_separator"));
		lblRole.setAlignment(SWT.RIGHT);

		cmbRole = new RoleIdListComposite(group_2, SWT.NONE, managerName, true, Mode.OWNER_ROLE);
		cmbRole.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 3, 1));
		cmbRole.getComboRoleId().addModifyListener(new ModifyListener() {
			public void modifyText(ModifyEvent e) {
				lblFacilityId.setText("");
				lblFacilityId.setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
				notifyInfo.setOwnerRoleId(cmbRole.getText(), true);
				checkFinished();
			}
		});

		Label lblFacilityid = new Label(group_2, SWT.NONE);
		lblFacilityid.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		lblFacilityid.setText(bundle_messages.getString("word.facility_id") + bundle_messages.getString("caption.title_separator"));
		lblFacilityid.setAlignment(SWT.RIGHT);
		
				lblFacilityId = new Label(group_2, SWT.BORDER);
				GridData gd_lblFacilityId = new GridData(SWT.FILL, SWT.CENTER, false, false, 2, 1);
				gd_lblFacilityId.widthHint = 290;
				lblFacilityId.setLayoutData(gd_lblFacilityId);
				lblFacilityId.setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);

		Button btnBrowse = new Button(group_2, SWT.NONE);
		GridData gd_btnBrowse = new GridData(SWT.FILL, SWT.FILL, false, false, 1, 1);
		gd_btnBrowse.widthHint = 70;
		btnBrowse.setLayoutData(gd_btnBrowse);
		btnBrowse.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				ScopeTreeDialog dialog = new ScopeTreeDialog(CreateBillingAlarmDialog.this.getShell(), managerName, cmbRole.getText(), false, false);

				if (dialog.open() == IDialogConstants.OK_ID) {
					FacilityTreeItem item = dialog.getSelectItem();
					FacilityInfo info = item.getData();
					lblFacilityId.setData(info.getFacilityId());
					if (info.getFacilityType() == FacilityConstant.TYPE_NODE) {
						lblFacilityId.setText(info.getFacilityName());
						lblFacilityId.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
					}
					else {
						FacilityPath path = new FacilityPath(ClusterControlPlugin.getDefault().getSeparator());
						lblFacilityId.setText(path.getPath(item));
						lblFacilityId.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
					}
					checkFinished();
				}
			}
		});
		btnBrowse.setText(bundle_messages.getString("word.browse") + "...");

		Label lblNewLabel_1 = new Label(group_2, SWT.NONE);
		lblNewLabel_1.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		lblNewLabel_1.setAlignment(SWT.RIGHT);
		lblNewLabel_1.setText(bundle_messages.getString("word.type") + bundle_messages.getString("caption.title_separator"));
		
				cmbType = new Combo(group_2, SWT.READ_ONLY);
				cmbType.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 3, 1));
				
						// 初期値設定
						cmbType.add(bundle_messages.getString("word.sum"));
						cmbType.setData(bundle_messages.getString("word.sum"), MonitorKind.SUM);
						cmbType.add(bundle_messages.getString("word.delta"));
						cmbType.setData(bundle_messages.getString("word.delta"), MonitorKind.DELTA);

		Group group = new Group(container, SWT.NONE);
		group.setLayout(new GridLayout(4, false));
		group.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 5, 1));
		group.setText(bundle_messages.getString("word.judge"));

		Label lblInfoThreshold = new Label(group, SWT.NONE);
		lblInfoThreshold.setAlignment(SWT.RIGHT);
		GridData gd_lblInfoThreshold = new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1);
		gd_lblInfoThreshold.widthHint = 77;
		lblInfoThreshold.setLayoutData(gd_lblInfoThreshold);
		lblInfoThreshold.setBackground(SWTResourceManager.getColor(SWT.COLOR_GREEN));
		lblInfoThreshold.setText(bundle_messages.getString("word.threshold_info") + bundle_messages.getString("caption.title_separator"));
				
						txtThresholdInfoLimit = new Text(group, SWT.BORDER | SWT.RIGHT);
						txtThresholdInfoLimit.addModifyListener(new ModifyListener() {
							public void modifyText(ModifyEvent e) {
								checkFinished();
							}
						});
						txtThresholdInfoLimit.addVerifyListener(new VerifyListener() {
							public void verifyText(VerifyEvent e) {
								try {
									String t = txtThresholdInfoLimit.getText().substring(0, e.start) + e.text + txtThresholdInfoLimit.getText().substring(e.end);
									if (t.length() != 0) {
										Double.valueOf(t);
									}
								}
								catch(Exception e1) {
									e.doit = false;
								}
							}
						});
						GridData gd_txtThresholdInfoLimit = new GridData(SWT.FILL, SWT.CENTER, false, false, 2, 1);
						gd_txtThresholdInfoLimit.widthHint = 50;
						txtThresholdInfoLimit.setLayoutData(gd_txtThresholdInfoLimit);

		Label label = new Label(group, SWT.NONE);
		label.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		label.setText(bundle_messages.getString("caption.threshold_info_description"));

		Label lblWarnThreshold = new Label(group, SWT.NONE);
		lblWarnThreshold.setAlignment(SWT.RIGHT);
		lblWarnThreshold.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		lblWarnThreshold.setBackground(SWTResourceManager.getColor(SWT.COLOR_YELLOW));
		lblWarnThreshold.setText(bundle_messages.getString("word.threshold_warn") + bundle_messages.getString("caption.title_separator"));
		
						txtThresholdWarnLimit = new Text(group, SWT.BORDER | SWT.RIGHT);
						txtThresholdWarnLimit.addModifyListener(new ModifyListener() {
							public void modifyText(ModifyEvent e) {
								checkFinished();
							}
						});
						txtThresholdWarnLimit.addVerifyListener(new VerifyListener() {
							public void verifyText(VerifyEvent e) {
								try {
									String t = txtThresholdWarnLimit.getText().substring(0, e.start) + e.text + txtThresholdWarnLimit.getText().substring(e.end);
									if (t.length() != 0) {
										Double.valueOf(t);
									}
								}
								catch(Exception e1) {
									e.doit = false;
								}
							}
						});
						GridData gd_txtThresholdWarnLimit = new GridData(SWT.FILL, SWT.CENTER, true, false, 2, 1);
						gd_txtThresholdWarnLimit.widthHint = 50;
						txtThresholdWarnLimit.setLayoutData(gd_txtThresholdWarnLimit);

		Label label_1 = new Label(group, SWT.NONE);
		GridData gd_label_1 = new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1);
		gd_label_1.widthHint = 327;
		label_1.setLayoutData(gd_label_1);
		label_1.setText(bundle_messages.getString("caption.threshold_warn_description"));

		Label lblAlert = new Label(group, SWT.NONE);
		lblAlert.setAlignment(SWT.RIGHT);
		lblAlert.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		lblAlert.setText(bundle_messages.getString("word.threshold_error") + bundle_messages.getString("caption.title_separator"));
		lblAlert.setBackground(SWTResourceManager.getColor(SWT.COLOR_RED));
		new Label(group, SWT.NONE);

		Label lblNewLabel = new Label(group, SWT.NONE);
		lblNewLabel.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 2, 1));
		lblNewLabel.setText(bundle_messages.getString("caption.threshold_error_description"));

		Group group_1 = new Group(container, SWT.NONE);
		group_1.setLayout(new GridLayout(1, false));
		group_1.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 5, 1));
		group_1.setText(bundle_messages.getString("word.notify"));

		// 通知情報（通知ID，アプリケーションID）
		this.notifyInfo = new NotifyIdListComposite(group_1, SWT.NONE, true);
		notifyInfo.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		notifyInfo.setManagerName(managerName);
		notifyInfo.setOwnerRoleId(cmbRole.getText(), true);

		btnValidFlg = new Button(container, SWT.CHECK);
		btnValidFlg.setLayoutData(new GridData(SWT.LEFT, SWT.CENTER, false, false, 5, 1));
		btnValidFlg.setText(bundle_messages.getString("caption.enabling_description"));
		btnValidFlg.setSelection(true);

		if (cmbType.getItemCount() != 0) {
			cmbType.select(0);
		}

		{
			DialogData output = getOutput();
			
			if (output.getAlarmId() != null)
				txtAlarmId.setText(output.getAlarmId());

			if (output.getAlarmName() != null)
				txtAlarmName.setText(output.getAlarmName());

			if (output.getDescription() != null)
				txtDescription.setText(output.getDescription());

			if (output.getOwnerRoleId() != null)
				cmbRole.setText(output.getOwnerRoleId());

			if (output.getOwnerRoleId() != null && output.getFacilityId() != null) {
				FacilityTreeItem item = null;
				try {
					item = searchFacilityTreeItem(
							RepositoryEndpointWrapper.getWrapper(this.managerName).getFacilityTree(output.getOwnerRoleId()), output.getFacilityId());
				} catch (HinemosUnknown_Exception | InvalidRole_Exception | InvalidUserPass_Exception e1) {
					Logger.getLogger(this.getClass()).warn(e1.getMessage(), e1);
				}
				if (item != null) {
					FacilityInfo info = item.getData();
					lblFacilityId.setData(info.getFacilityId());
					if (info.getFacilityType() == FacilityConstant.TYPE_NODE) {
						lblFacilityId.setText(info.getFacilityName());
						lblFacilityId.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
					} else {
						FacilityPath path = new FacilityPath(ClusterControlPlugin.getDefault().getSeparator());
						lblFacilityId.setText(path.getPath(item));
						lblFacilityId.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
					}
				}
			}
			
			if (output.getMonitorKind() != null) {
				for (String item: cmbType.getItems()) {
					if (((MonitorKind)cmbType.getData(item)).value().equals(output.getMonitorKind().name())) {
						cmbType.setText(item);
						break;
					}
				}
			}

			if (output.getThresholdInfoLimit() != null)
				txtThresholdInfoLimit.setText(String.valueOf(output.getThresholdInfoLimit()));

			if (output.getThresholdWarnLimit() != null)
				txtThresholdWarnLimit.setText(String.valueOf(output.getThresholdWarnLimit()));

			notifyInfo.setOwnerRoleId(cmbRole.getText(), true);
			if (output.getNotifyRelationInfos() != null)
				notifyInfo.setNotify(new ArrayList<>(output.getNotifyRelationInfos()));

			btnValidFlg.setSelection(output.getValidFlg() == null ? false: output.getValidFlg());
		}
		
		if (!PlatformDependent.getPlatformDependent().isRapPlatfome()) {
			container.layout();
			Control[] labels = new Control[]{lblAlarmId, lblAlarmName, lblRole, lblFacilityid, lblNewLabel_1, lblInfoThreshold, lblWarnThreshold, lblAlert};
			int maxWidth = 0;
			for (Control l: labels) {
				Point p = l.getSize();
				maxWidth = Math.max(maxWidth, p.x);
			}
			for (Control l: labels) {
				((GridData)l.getLayoutData()).widthHint = maxWidth;
			}
			group_2.layout(true);
			group.layout(true);
		}
		
		ControlUtil.setRequired(txtAlarmId, txtAlarmName, lblNewLabel_1, txtDescription, txtThresholdInfoLimit, txtThresholdWarnLimit);
		
		getShell().getDisplay().asyncExec(new Runnable() {
			@Override
			public void run() {
				checkFinished();
			}
		});
		return container;
	}

	public List<NotifyRelationInfo> getNotifyRelationInfoList() {
		return notifyRelationInfoList;
	}

	@Override
	protected void okPressed() {
		Double infoLimit = null;
		Double warnLimit = null;
		try {
			infoLimit = Double.valueOf(txtThresholdInfoLimit.getText());
			warnLimit = Double.valueOf(txtThresholdWarnLimit.getText());
		}
		catch (Exception e) {
			MessageDialog.openError(null,
					Messages.getString("failed"),
					msgBillingAlarmInvalidLimit);
			return;
		}

		output.setAlarmId(txtAlarmId.getText());
		output.setAlarmName(txtAlarmName.getText());
		output.setDescription(txtDescription.getText());
		output.setOwnerRoleId(cmbRole.getText());
		output.setFacilityId(lblFacilityId.getData().toString());
		output.setMonitorKind((MonitorKind)cmbType.getData(cmbType.getText()));
		output.setThresholdInfoLimit(infoLimit);
		output.setThresholdWarnLimit(warnLimit);
		output.setValidFlg(btnValidFlg.getSelection());

		output.getNotifyRelationInfos().clear();
		if (notifyInfo.getNotify() != null && !notifyInfo.getNotify().isEmpty())
			output.getNotifyRelationInfos().addAll(notifyInfo.getNotify());

		super.okPressed();
	}

	public static FacilityTreeItem searchFacilityTreeItem(FacilityTreeItem item, String facilityId) {
		if (item.getData().getFacilityId().equals(facilityId)) {
			return item;
		}
		else {
			for (FacilityTreeItem child: item.getChildren()) {
				FacilityTreeItem matched = searchFacilityTreeItem(child, facilityId);
				if (matched != null) {
					return matched;
				}
			}
			return null;
		}
	}

	public DialogData getOutput() {
		if (this.output == null)
			output = factory.createDialogData();
		return output;
	}
	
	/**
	 * Create contents of the button bar.
	 * @param parent
	 */
	@Override
	protected void createButtonsForButtonBar(Composite parent) {
		createButton(parent, IDialogConstants.OK_ID, IDialogConstants.OK_LABEL,
				true);
		createButton(parent, IDialogConstants.CANCEL_ID,
				IDialogConstants.CANCEL_LABEL, false);
	}

	/**
	 * Return the initial size of the dialog.
	 */
	@Override
	protected Point getInitialSize() {
		return new Point(550, 619);
	}

	@Override
	protected void configureShell(Shell newShell) {
		super.configureShell(newShell);
		newShell.setText(bundle_messages.getString("caption.charge_alert_dialog"));
	}
	
	protected void checkFinished() {
		Button okButton = getButton(IDialogConstants.OK_ID);
		if (okButton == null)
			return;
		
		if (txtAlarmId != null && !txtAlarmId.getText().isEmpty() &&
			txtAlarmName != null && !txtAlarmName.getText().isEmpty() &&
			txtThresholdInfoLimit != null && !txtThresholdInfoLimit.getText().isEmpty() &&
			txtThresholdWarnLimit != null && !txtThresholdWarnLimit.getText().isEmpty() &&
			txtDescription != null && !txtDescription.getText().isEmpty() &&
			lblFacilityId != null && !lblFacilityId.getText().isEmpty() &&
			cmbRole != null && !cmbRole.getText().isEmpty()
			) {
			getButton(IDialogConstants.OK_ID).setEnabled(true);
		} else {
			getButton(IDialogConstants.OK_ID).setEnabled(false);
		}
	}
}