/*
Copyright (C) 2015 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.xcloud.ui.dialogs;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.swt.SWTResourceManager;

import com.clustercontrol.xcloud.common.CloudStringConstants;
import com.clustercontrol.xcloud.model.cloud.ICloudScope;
import com.clustercontrol.xcloud.model.cloud.ILoginUser;
import com.clustercontrol.xcloud.model.cloud.IRoleRelation;
import com.clustercontrol.xcloud.ui.views.HinemosRole;

public class EditAssignRoleDialog extends Dialog implements CloudStringConstants {
	public static final long serialVersionUID = 1L;

	public static class DialogOutput{
		private String cloudScopeId;
		private String cloudUserId;
		public String getCloudScopeId() {return cloudScopeId;}
		public void setCloudScopeId(String cloudScopeId) {this.cloudScopeId = cloudScopeId;}
		public String getCloudUserId() {return cloudUserId;}
		public void setCloudUserId(String cloudUserId) {this.cloudUserId = cloudUserId;}
	}

	private List<DialogOutput> output;

	private Map<String, String> relationMap = new HashMap<String, String>();

	private HinemosRole role;

	/**
	 * Create the dialog.
	 * @param parentShell
	 */
	public EditAssignRoleDialog(Shell parentShell, HinemosRole role) {
		super(parentShell);
		setShellStyle(SWT.CLOSE | SWT.RESIZE | SWT.TITLE | SWT.APPLICATION_MODAL);
		this.role = role;
	}

	/**
	 * Create contents of the dialog.
	 * @param parent
	 */
	@Override
	protected Control createDialogArea(Composite parent) {
		Composite area = (Composite) super.createDialogArea(parent);
		Composite container = new Composite(area, SWT.FILL);
		container.setBackground(SWTResourceManager.getColor(SWT.COLOR_WIDGET_BACKGROUND));
		GridLayout gl_container = new GridLayout(10, true);
		gl_container.marginWidth = 0;
		gl_container.verticalSpacing = 20;
		gl_container.horizontalSpacing = 0;
		container.setLayout(gl_container);
		GridData gd_container = new GridData(SWT.FILL, SWT.FILL, true, false);
		gd_container.verticalAlignment = SWT.FILL;
		gd_container.horizontalAlignment = SWT.FILL;
		container.setLayoutData(gd_container);

		Label lblManager = new Label(container, SWT.RIGHT);
		lblManager.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, false, 1, 1));
		lblManager.setText(strManager + " " + strSeparator + " ");

		Label txtManager = new Label(container, SWT.LEFT);
		txtManager.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, false, 4, 1));
		txtManager.setText(role.getManager().getManagerName());

		Label lblRole = new Label(container, SWT.RIGHT);
		lblRole.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, false, 1, 1));
		lblRole.setText(strRole + " " + strSeparator + " ");

		Label txtRole = new Label(container, SWT.LEFT);
		txtRole.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, false, 4, 1));
		txtRole.setText(role.getRoleInfo().getName());

		ScrolledComposite scrolledComposite = new ScrolledComposite(container, SWT.V_SCROLL);
		GridLayout gl_scrlcmp = new GridLayout(1, true);
		gl_scrlcmp.marginTop = 0;
		gl_scrlcmp.marginLeft = 0;
		gl_scrlcmp.marginRight = 0;
		gl_scrlcmp.marginBottom = 0;
		gl_scrlcmp.marginHeight = 0;
		gl_scrlcmp.marginWidth = 0;
		gl_scrlcmp.horizontalSpacing = 0;
		gl_scrlcmp.verticalSpacing = 0;
		scrolledComposite.setLayout(gl_scrlcmp);
		scrolledComposite.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 10, 1));
		((GridData)scrolledComposite.getLayoutData()).widthHint = 100;

		Composite cmpTable = new Composite(scrolledComposite, SWT.NONE);
		GridLayout gl_table = new GridLayout(20, true);
		gl_table.marginTop = 0;
		gl_table.marginLeft = 0;
		gl_table.marginRight = 0;
		gl_table.marginBottom = 0;
		gl_table.marginHeight = 0;
		gl_table.marginWidth = 0;
		gl_table.horizontalSpacing = 0;
		gl_table.verticalSpacing = 0;
		cmpTable.setLayout(gl_table);
		cmpTable.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));

		init(cmpTable);

		scrolledComposite.setContent(cmpTable);
		cmpTable.setSize(cmpTable.computeSize(SWT.DEFAULT, SWT.DEFAULT));
		new Label(cmpTable, SWT.NONE);
		new Label(cmpTable, SWT.NONE);
		new Label(cmpTable, SWT.NONE);
		new Label(cmpTable, SWT.NONE);
		new Label(cmpTable, SWT.NONE);
		new Label(cmpTable, SWT.NONE);
		new Label(cmpTable, SWT.NONE);
		new Label(cmpTable, SWT.NONE);
		new Label(cmpTable, SWT.NONE);
		new Label(cmpTable, SWT.NONE);
		new Label(cmpTable, SWT.NONE);
		new Label(cmpTable, SWT.NONE);
		new Label(cmpTable, SWT.NONE);
		new Label(cmpTable, SWT.NONE);

		((GridData)scrolledComposite.getLayoutData()).widthHint = ((GridData)area.getLayoutData()).widthHint;

		area.layout();

		return area;
	}

	protected void init(Composite tableCompsite){
		assert role != null;

		createColumnTitle(tableCompsite);

		for(ICloudScope scope: role.getManager().getCloudScopes().getCloudScopes()){
			createRow(tableCompsite, scope);
		}
	}

	protected void createColumnTitle(Composite tableCompsite){
		createCell(tableCompsite, strCloudPlatform, 6, SWTResourceManager.getColor(SWT.COLOR_WIDGET_FOREGROUND), SWTResourceManager.getColor(SWT.COLOR_GRAY));
		createCell(tableCompsite, strCloudScope, 6, SWTResourceManager.getColor(SWT.COLOR_WIDGET_FOREGROUND), SWTResourceManager.getColor(SWT.COLOR_GRAY));
		createCell(tableCompsite, strAssignedUser, 8, SWTResourceManager.getColor(SWT.COLOR_WIDGET_FOREGROUND), SWTResourceManager.getColor(SWT.COLOR_GRAY));
	}

	protected void createCell(Composite tableCompsite, String title, int colSize, Color foreColor, Color backColor){
		Composite composite = new Composite(tableCompsite, SWT.BORDER);
		composite.setBackground(backColor);
		GridLayout layout = new GridLayout(1, true);
		layout.marginLeft = 0;
		layout.marginRight = 0;
		layout.marginWidth = 0;
		layout.horizontalSpacing = 0;
		layout.verticalSpacing = 5;
		composite.setLayout(layout);
		composite.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, false, colSize, 1));
		Text label = new Text(composite, SWT.LEFT | SWT.READ_ONLY);
		label.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, false, 1, 1));
		((GridData)label.getLayoutData()).horizontalIndent = 5;
		label.setText(title);
		label.setForeground(foreColor);
		label.setBackground(backColor);
	}


	protected void createRow(Composite tableCompsite, final ICloudScope scope){
		createCell(tableCompsite, scope.getCloudPlatform().getName() + " ( " + scope.getPlatformId() + " )", 6, SWTResourceManager.getColor(SWT.COLOR_BLACK), SWTResourceManager.getColor(SWT.COLOR_WHITE));
		createCell(tableCompsite, scope.getName() + " ( " + scope.getId() + " )", 6, SWTResourceManager.getColor(SWT.COLOR_BLACK), SWTResourceManager.getColor(SWT.COLOR_WHITE));

		Composite cmpAssignUser = new Composite(tableCompsite, SWT.BORDER);
		cmpAssignUser.setBackground(SWTResourceManager.getColor(SWT.COLOR_WHITE));
		GridLayout gl_assignUser = new GridLayout(1, true);
		gl_assignUser.verticalSpacing = 5;
		cmpAssignUser.setLayout(gl_assignUser);
		cmpAssignUser.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, false, 8, 1));
		Button btnUnassign = new Button(cmpAssignUser, SWT.RADIO);
		btnUnassign.setBackground(SWTResourceManager.getColor(SWT.COLOR_WHITE));
		btnUnassign.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, false, 1, 1));
		btnUnassign.setText(strUnassgin);
		btnUnassign.setSelection(true);
		btnUnassign.addSelectionListener(new SelectionAdapter(){
			@Override
			public void widgetSelected(SelectionEvent e) {
				relationMap.remove(scope.getId());
			}
		});
		for(final ILoginUser user: scope.getLoginUsers().getLoginUsers()){
			Button btnUser = new Button(cmpAssignUser, SWT.RADIO);
			btnUser.setBackground(SWTResourceManager.getColor(SWT.COLOR_WHITE));
			btnUser.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, false, 1, 1));
			btnUser.setText(user.getName() + " ( " + user.getId() + " )" + (scope.getAccountId().equals(user.getId()) ? " [" + strMain + "]":""));
			for(IRoleRelation relation: user.getRoleRelations()){
				if(relation.getId().equals(role.getRoleInfo().getId())){
					btnUnassign.setSelection(false);
					btnUser.setSelection(true);
					relationMap.put(scope.getId(), user.getId());
				}
			}
			btnUser.addSelectionListener(new SelectionAdapter(){
				@Override
				public void widgetSelected(SelectionEvent e) {
					relationMap.put(scope.getId(), user.getId());
				}
			});
		}
	}

	/**
	 * Create contents of the button bar.
	 * @param parent
	 */
	@Override
	protected void createButtonsForButtonBar(Composite parent) {
		createButton(parent, IDialogConstants.OK_ID, IDialogConstants.OK_LABEL,
				false);
		createButton(parent, IDialogConstants.CANCEL_ID,
				IDialogConstants.CANCEL_LABEL, false);
	}

	/**
	 * Return the initial size of the dialog.
	 */
	@Override
	protected Point getInitialSize() {
		return new Point(780, 640);
	}

	@Override
	protected void okPressed() {
		output = new ArrayList<>();
		for(Map.Entry<String, String> entry: relationMap.entrySet()){
			DialogOutput item = new DialogOutput();
			item.setCloudScopeId(entry.getKey());
			item.setCloudUserId(entry.getValue());
			output.add(item);
		}

		setReturnCode(OK);
		close();
	}

	@Override
	protected void configureShell(Shell newShell) {
		super.configureShell(newShell);
		newShell.setText(dlgRoleAddModify);
	}

	public List<DialogOutput> getOutput() {
		return output;
	}
}
