package com.clustercontrol.xcloud.ui.dialogs.job;

import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

import com.clustercontrol.xcloud.common.CloudStringConstants;

public class JobDetailPage extends WizardPage implements CloudStringConstants {
	public static final long serialVersionUID = 1L;
	public static final String pageName = JobDetailPage.class.getName();

	private Text text;
	private Text text_1;

	/**
	 * Create the wizard.
	 */
	public JobDetailPage() {
		super(pageName);
		setTitle(msgSetingJob);
		setDescription(msgInputJobDetail);
	}

	/**
	 * Create contents of the wizard.
	 * @param parent
	 */
	public void createControl(Composite parent) {
		Composite container = new Composite(parent, SWT.NULL);

		setControl(container);
		container.setLayout(new GridLayout(3, false));
		
		Label lblNewLabel = new Label(container, SWT.RIGHT);
		lblNewLabel.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		lblNewLabel.setText(strJobId + strSeparator);
		
		text = new Text(container, SWT.BORDER);
		text.addModifyListener(new ModifyListener() {
			public void modifyText(ModifyEvent e) {
				getContainer().updateButtons();
			}
		});
		text.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, false, 2, 1));
		
		Label lblNewLabel_1 = new Label(container, SWT.RIGHT);
		lblNewLabel_1.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		lblNewLabel_1.setText(strJobName + strSeparator);
		
		text_1 = new Text(container, SWT.BORDER);
		text_1.addModifyListener(new ModifyListener() {
			public void modifyText(ModifyEvent e) {
				getContainer().updateButtons();
			}
		});
		text_1.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, false, 2, 1));
	}
	
	public String getJobId() {
		return text.getText();
	}
	public void setJobId(String jobId) {
		text.setText(jobId);
	}
	
	public String getJobName() {
		return text_1.getText();
	}
	public void setJobName(String jobName) {
		text_1.setText(jobName);
	}
	
	@Override
	public boolean isPageComplete() {
		return super.isPageComplete() && text_1.getText() != null && !text_1.getText().isEmpty() && text.getText() != null && !text.getText().isEmpty();
	}
}