/*
Copyright (C) 2015 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */

package com.clustercontrol.xcloud.ui.handlers;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.Calendar;
import java.util.Date;

import javax.activation.DataHandler;

import org.apache.log4j.Logger;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.handlers.HandlerUtil;

import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.xcloud.CloudEndpoint;
import com.clustercontrol.ws.xcloud.TargetType;
import com.clustercontrol.xcloud.model.cloud.IBillingAlarm;
import com.clustercontrol.xcloud.platform.PlatformDependent;

public class ExportBillingDetailForFacilityHandler extends AbstractHandler {
	public static final String ID = ExportBillingDetailForFacilityHandler.class.getName();

	@Override
	public Object execute(ExecutionEvent event) throws ExecutionException {
		IStructuredSelection selection = (IStructuredSelection)HandlerUtil.getActiveSite(event).getSelectionProvider().getSelection();
		final IBillingAlarm billingAlarm = (IBillingAlarm)selection.getFirstElement();
		
		Calendar calendar = Calendar.getInstance();
		calendar.setTime(new Date());

		try {
			DataHandler handler = billingAlarm.getBillingAlarms().getHinemosManager().getEndpoint(CloudEndpoint.class).downloadBillingDetailsByFacility(
					billingAlarm.getFacilityId(),
					calendar.get(Calendar.YEAR),
					calendar.get(Calendar.MONTH) + 1);

			PlatformDependent.getPlatformDependent().downloadBillingDetail(
					HandlerUtil.getActiveShell(event),
					TargetType.FACILITY,
					billingAlarm.getFacilityId(),
					calendar.get(Calendar.YEAR),
					calendar.get(Calendar.MONTH) + 1,
					handler);
		} catch (Exception e) {
			Logger logger = Logger.getLogger(this.getClass());
			logger.error(e.getMessage(), e);

			String message = e.getMessage();
			if (message == null) {
				ByteArrayOutputStream bos = new ByteArrayOutputStream();
				PrintStream ps = new PrintStream(bos, true);
				e.printStackTrace(ps);
				
				message = bos.toString();
			}
			
			// 失敗報告ダイアログを生成
			MessageDialog.openError(null, Messages.getString("failed"), message);
		}
		return null;
	}
}