
package com.clustercontrol.ws.xcloud;

import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlType;


/**
 * <p>monitorKindのJavaクラス。
 * 
 * <p>次のスキーマ・フラグメントは、このクラス内に含まれる予期されるコンテンツを指定します。
 * <p>
 * <pre>
 * &lt;simpleType name="monitorKind">
 *   &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     &lt;enumeration value="delta"/>
 *     &lt;enumeration value="sum"/>
 *   &lt;/restriction>
 * &lt;/simpleType>
 * </pre>
 * 
 */
@XmlType(name = "monitorKind")
@XmlEnum
public enum MonitorKind {

    @XmlEnumValue("delta")
    DELTA("delta"),
    @XmlEnumValue("sum")
    SUM("sum");
    private final String value;

    MonitorKind(String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    public static MonitorKind fromValue(String v) {
        for (MonitorKind c: MonitorKind.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
