/*

Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol;

import org.eclipse.ui.IPageLayout;
import org.eclipse.ui.IPerspectiveFactory;

import com.clustercontrol.plugin.menu.LoadMenuPlugin;

/**
 * 基底パースペクティブ<BR>
 * 
 * パースペクティブはこのクラスを継承すること。
 * 
 * 
 * @version 4.1.0
 * @since 1.0.0
 */
public class ClusterControlPerspectiveBase implements IPerspectiveFactory{

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.ui.IPerspectiveFactory#createInitialLayout(org.eclipse.ui.IPageLayout)
	 */
	@Override
	public void createInitialLayout(IPageLayout layout) {

		//エディタを非表示
		layout.setEditorAreaVisible(false);

		//アクションセットを追加
		layout.addActionSet("com.clustercontrol.ActionSet");
		layout.addActionSet("com.clustercontrol.common.ActionSet");
		layout.addActionSet("com.clustercontrol.calendar.ActionSet");
		layout.addActionSet("com.clustercontrol.repository.ActionSet");
		layout.addActionSet("com.clustercontrol.collectiverun.ActionSet");
		layout.addActionSet("com.clustercontrol.monitor.view.ActionSet");
		layout.addActionSet("com.clustercontrol.monitor.run.ActionSet");
		layout.addActionSet("com.clustercontrol.jobmanagement.ActionSet");
		layout.addActionSet("com.clustercontrol.performance.ActionSet");
		layout.addActionSet("com.clustercontrol.accesscontrol.ActionSet");

		layout.addActionSet("com.clustercontrol.vm.ActionSet");
		layout.addActionSet("com.clustercontrol.nodemap.ActionSet");
		layout.addActionSet("com.clustercontrol.jobmap.ActionSet");
		layout.addActionSet("com.clustercontrol.openflow.ActionSet");
		layout.addActionSet("com.clustercontrol.utilityoption.ActionSet");
		
		//menu 追加用
		for(String actionSetId: LoadMenuPlugin.getExtensionMenuList()){
			layout.addActionSet(actionSetId);
		}
	}
}