/*

Copyright (C) 2006 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.collectiverun.composite.action;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;

import com.clustercontrol.collectiverun.composite.TreeComposite;
import com.clustercontrol.collectiverun.util.TreeItemUtil;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.collectiverun.ItemInfo;
import com.clustercontrol.ws.collectiverun.TreeItem;

/**
 * 一括制御階層ツリーのSelectionListener基底クラス
 * 
 * @version 2.1.0
 * @since 2.1.0
 */
public class BaseTreeItemSelectionListener implements SelectionListener {
	protected TreeComposite composite;

	/**
	 * コンストラクタ
	 * 
	 * @param composite
	 */
	public BaseTreeItemSelectionListener(TreeComposite composite) {
		this.composite = composite;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.swt.events.SelectionListener#widgetSelected(org.eclipse.swt.events.SelectionEvent)
	 */
	@Override
	public void widgetSelected(SelectionEvent event) {

	}

	/**
	 * 作成中アイテムチェック
	 * @return
	 */
	protected boolean checkCreateItem() {

		//作成中のアイテムが存在するかチェック
		if(this.composite.getCreateItem() != null){
			//作成中アイテムが存在する場合

			TreeItem createItem = this.composite.getCreateItem();
			TreeItem parent = createItem.getParent();

			//削除確認ダイアログを生成
			Object[] args = { getInfo(createItem).getName() };
			if (MessageDialog.openConfirm(
					null,
					Messages.getString("confirmed"),
					Messages.getString("message.collective.run.8", args))) {

				TreeItemUtil.removeChildren(parent, createItem);
				this.composite.setCreateItem(null);
				this.composite.setUpdateItem(null);

				this.composite.getTreeViewer().refresh(parent);
			}
			return false;
		}
		return true;
	}

	/**
	 * 更新中アイテムチェック
	 * @return
	 */
	protected boolean checkUpdateItem() {

		//選択アイテムを取得
		TreeItem selectItem = this.composite.getSelectItem();

		//更新中のアイテムが存在するかチェック
		if(this.composite.getUpdateItem() != null){
			//更新中アイテムが存在する場合

			TreeItem updateItem = this.composite.getUpdateItem();

			//削除確認ダイアログを生成
			Object[] args = { getInfo(updateItem).getName() };
			if (MessageDialog.openConfirm(
					null,
					Messages.getString("confirmed"),
					Messages.getString("message.collective.run.9", args))) {

				this.composite.setUpdateItem(null);

				this.composite.getTreeViewer().setSelection(
						new StructuredSelection(selectItem), true);
			}
			return false;
		}
		return true;
	}

	private ItemInfo getInfo(TreeItem item){
		if(item.getCommandInfo() != null){
			return item.getCommandInfo();
		}
		else if(item.getCommandParameterInfo() != null){
			return item.getCommandParameterInfo();
		}
		else if(item.getParameterInfo() != null){
			return item.getParameterInfo();
		}
		else if(item.getParameterSelectInfo() != null){
			return item.getParameterSelectInfo();
		}
		else if(item.getTypeInfo() != null){
			return item.getTypeInfo();
		}
		else{
			return null;
		}
	}

	/* (non-Javadoc)
	 * @see org.eclipse.swt.events.SelectionListener#widgetDefaultSelected(org.eclipse.swt.events.SelectionEvent)
	 */
	@Override
	public void widgetDefaultSelected(SelectionEvent e) {

	}
}

