/*

Copyright (C) 2006 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.collectiverun.viewer;

import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

import com.clustercontrol.collectiverun.bean.ItemImageConstant;
import com.clustercontrol.ws.collectiverun.ItemInfo;
import com.clustercontrol.ws.collectiverun.TreeItem;

/**
 * 一括制御ツリーLabelProviderクラス
 * 
 * @version 2.1.0
 * @since 2.1.0
 */
public class TreeLabelProvider extends LabelProvider {


	@Override
	public String getText(Object element) {
		ItemInfo info = getInfo(((TreeItem) element));

		if(info.getName() != null)
			return info.getName();
		else
			return "";
	}

	@Override
	public Image getImage(Object element) {
		int type = getInfo(((TreeItem) element)).getType();

		return ItemImageConstant.typeToImage(type);
	}

	private ItemInfo getInfo(TreeItem item){
		if(item.getCommandInfo() != null){
			return item.getCommandInfo();
		}
		else if(item.getCommandParameterInfo() != null){
			return item.getCommandParameterInfo();
		}
		else if(item.getParameterInfo() != null){
			return item.getParameterInfo();
		}
		else if(item.getParameterSelectInfo() != null){
			return item.getParameterSelectInfo();
		}
		else if(item.getTypeInfo() != null){
			return item.getTypeInfo();
		}
		else{
			return null;
		}
	}
}