/*

Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.jobmanagement.action;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.dialogs.MessageDialog;

import com.clustercontrol.jobmanagement.util.JobEndpointWrapper;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.jobmanagement.JobFileCheck;
import com.clustercontrol.ws.jobmanagement.JobKick;
import com.clustercontrol.ws.jobmanagement.JobSchedule;

/**
 * ジョブ[実行契機]情報[スケジュール&ファイルチェック]
 * を取得するクライアント側アクションクラス<BR>
 * 
 * @version 4.1.0
 * @since 4.1.0
 */
public class GetJobKick {

	// ログ
	private static Log m_log = LogFactory.getLog( GetJobKick.class );

	/**
	 * 実行契機[スケジュール]情報を返します。<BR>
	 * 
	 * @param scheduleId 実行契機ID
	 * @return 実行契機[スケジュール]情報
	 */
	public static JobSchedule getJobSchedule(String scheduleId) {
		JobSchedule jobSchedule  = null;
		try {
			jobSchedule  =JobEndpointWrapper.getJobSchedule(scheduleId);
		} catch (Exception e) {
			// 上記以外の例外
			m_log.warn("getJobSchedule(), " + e.getMessage(), e);
			MessageDialog.openInformation(
					null,
					Messages.getString("message"),
					Messages.getString("message.hinemos.failure.unexpected") + ", " + e.getMessage());
		}
		return jobSchedule ;
	}

	/**
	 * 実行契機[ファイルチェック]情報を返します。<BR>
	 * 
	 * @param scheduleId 実行契機ID
	 * @return 実行契機[ファイルチェック]情報
	 */
	public static JobFileCheck getJobFileCheck(String scheduleId) {
		JobFileCheck jobFileCheck = null;
		try {
			jobFileCheck  =JobEndpointWrapper.getJobFileCheck(scheduleId);
		} catch (Exception e) {
			// 上記以外の例外
			m_log.warn("getJobFileCheck(), " + e.getMessage(), e);
			MessageDialog.openInformation(
					null,
					Messages.getString("message"),
					Messages.getString("message.hinemos.failure.unexpected") + ", " + e.getMessage());
		}
		return jobFileCheck ;
	}
	/**
	 * IDと一致する実行契機[スケジュール or ファイルチェック]を返します<BR>
	 * @param jobKickId
	 * @return
	 */
	public static JobKick getJobKick(String jobKickId){
		List<JobKick> jobKickList = new ArrayList<JobKick>();
		try {
			jobKickList  =JobEndpointWrapper.getJobKickList();
		} catch (Exception e) {
			// 上記以外の例外
			m_log.warn("getJobFileCheck(), " + e.getMessage(), e);
			MessageDialog.openInformation(
					null,
					Messages.getString("message"),
					Messages.getString("message.hinemos.failure.unexpected") + ", " + e.getMessage());
		}
		JobKick retJobKick = null;
		//IDと一致するものを探索
		for(JobKick jobKick : jobKickList){
			if(jobKick.getId().equals(jobKickId)){
				retJobKick = jobKick;
			}
		}
		return retJobKick;
	}
}