/*

Copyright (C) 2006 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.jobmanagement.view.action;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

import com.clustercontrol.jobmanagement.bean.JobTriggerTypeConstant;
import com.clustercontrol.jobmanagement.util.JobEditStateUtil;
import com.clustercontrol.jobmanagement.util.JobEndpointWrapper;
import com.clustercontrol.jobmanagement.view.JobListView;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.jobmanagement.InvalidRole_Exception;
import com.clustercontrol.ws.jobmanagement.JobTreeItem;
import com.clustercontrol.ws.jobmanagement.JobTriggerInfo;

/**
 * ジョブ[一覧]ビューの「実行」のクライアント側アクションクラス<BR>
 * 
 * @version 2.0.0
 * @since 1.0.0
 */
public class RunJobAction implements IViewActionDelegate {

	// ログ
	private static Log m_log = LogFactory.getLog( RunJobAction.class );

	/** アクションID */
	public static final String ID = "com.clustercontrol.jobmanagement.view.action.RunJobAction";
	/** ビュー */
	private IViewPart m_view;

	/**
	 * ビューを保持します。ワークベンチにロードされた際に呼ばれます。
	 * 
	 * @param view ビューのインスタンス
	 * 
	 * @see org.eclipse.ui.IViewActionDelegate#init(org.eclipse.ui.IViewPart)
	 */
	@Override
	public void init(IViewPart view) {
		m_view = view;
	}

	/**
	 * ジョブ[一覧]ビューの「登録」が押された場合に、ジョブを登録します。
	 * <p>
	 * <ol>
	 * <li>ジョブ[一覧]ビューから選択されたジョブツリーアイテムを取得します。</li>
	 * <li>実行の確認ダイアログを表示します。</li>
	 * <li>ジョブを実行します。</li>
	 * </ol>
	 * 
	 * @see org.eclipse.ui.IActionDelegate#run(org.eclipse.jface.action.IAction)
	 * @see com.clustercontrol.jobmanagement.view.JobListView
	 * @see com.clustercontrol.jobmanagement.action.RunJob#runJob(String)
	 */
	@Override
	public void run(IAction action) {
		JobTreeItem item = null;

		if (m_view instanceof JobListView) {
			JobListView view = (JobListView) m_view
					.getAdapter(JobListView.class);

			if(JobEditStateUtil.isEdit()){
				// 確認ダイアログを生成
				MessageDialog.openWarning(
						null,
						Messages.getString("confirmed"),
						Messages.getString("message.job.43") + "\n" +
								Messages.getString("message.job.44"));
				return;
			}

			item = view.getSelectJobTreeItem();

			if (item instanceof JobTreeItem) {
				// 確認ダイアログを生成
				Object[] args1 = { item.getData().getName(), item.getData().getId(), item.getData().getJobunitId() };
				if (MessageDialog.openQuestion(
						null,
						Messages.getString("confirmed"),
						Messages.getString(Messages.getString("message.job.32"), args1))) {
					//ジョブ実行
					try {
						// 実行契機情報を登録
						JobTriggerInfo triggerInfo = new JobTriggerInfo();
						triggerInfo.setTriggerType(JobTriggerTypeConstant.TYPE_MANUAL);

						JobEndpointWrapper.runJob(
								item.getData().getJobunitId(),
								item.getData().getId(),
								null,
								triggerInfo);
					} catch (InvalidRole_Exception e) {
						MessageDialog.openInformation(null, Messages.getString("message"),
								Messages.getString("message.accesscontrol.16"));
					} catch (Exception e) {
						m_log.warn("run(), " + e.getMessage(), e);
						MessageDialog.openError(
								null,
								Messages.getString("failed"),
								Messages.getString("message.hinemos.failure.unexpected") + ", " + e.getMessage());
					}
				}
			}
		}
	}

	/* (non-Javadoc)
	 * @see org.eclipse.ui.IActionDelegate#selectionChanged(org.eclipse.jface.action.IAction, org.eclipse.jface.viewers.ISelection)
	 */
	@Override
	public void selectionChanged(IAction action, ISelection selection) {

	}
}