/*

 Copyright (C) 2006 NTT DATA Corporation

 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation, version 2.

 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.monitor.dialog;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.TableTree;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

import com.clustercontrol.bean.Property;
import com.clustercontrol.dialog.CommonDialog;
import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.monitor.action.GetEventReportProperty;
import com.clustercontrol.monitor.bean.OutputFormConstant;
import com.clustercontrol.util.Messages;
import com.clustercontrol.util.PropertyUtil;
import com.clustercontrol.viewer.PropertySheet;

/**
 * 監視[イベントのダウンロード]ダイアログクラス<BR>
 * 
 * @version 2.1.0
 * @since 2.1.0
 */
public class EventReportDialog extends CommonDialog {

	// 後でpackするためsizeXはダミーの値。
	private final int sizeX = 600;
	private final int sizeY = 600;

	/** プロパティシート。 */
	private PropertySheet propertySheet = null;

	/**
	 * プロパティ。
	 * 前回ダイアログオープン時の情報を保持するために使用します。
	 */
	private static Property filterProperty = null;

	/** 出力先テキスト。 */
	private Text m_textRedirect = null;

	/** 出力先ボタン。 */
	private Button m_buttonRedirect = null;

	/**
	 * 出力形式。
	 * @see com.clustercontrol.bean.OutputFormConstant
	 */
	private int m_outputForm = OutputFormConstant.TYPE_PDF;

	/** 出力先パス。 */
	private String m_redirect = null;

	/**
	 * インスタンスを返します。
	 * 
	 * @param parent 親のシェルオブジェクト
	 */
	public EventReportDialog(Shell parent) {
		super(parent);
	}

	/**
	 * ダイアログの初期サイズを返します。
	 * 
	 * @return 初期サイズ
	 */
	@Override
	protected Point getInitialSize() {
		return new Point(sizeX, sizeY);
	}

	/**
	 * ダイアログエリアを生成します。
	 * 
	 * @param parent 親のコンポジット
	 * 
	 * @see com.clustercontrol.monitor.action.GetEventReportProperty#getProperty()
	 */
	@Override
	protected void customizeDialog(Composite parent) {
		Shell shell = this.getShell();

		// 変数として利用されるラベル
		Label label = null;
		// 変数として利用されるグリッドデータ
		GridData gridData = null;

		// タイトル
		shell.setText(Messages.getString("dialog.monitor.events.download"));

		// レイアウト
		GridLayout layout = new GridLayout(1, true);
		layout.marginWidth = 10;
		layout.marginHeight = 10;
		layout.numColumns = 15;
		parent.setLayout(layout);

		/*
		 * 出力先
		 */
		// ラベル
		label = new Label(parent, SWT.NONE);
		gridData = new GridData();
		gridData.horizontalSpan = 3;
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		label.setLayoutData(gridData);
		label.setText(Messages.getString("redirect") + " : ");
		// テキスト
		this.m_textRedirect = new Text(parent, SWT.BORDER | SWT.LEFT);
		gridData = new GridData();
		gridData.horizontalSpan = 10;
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		this.m_textRedirect.setLayoutData(gridData);
		// 参照ボタン
		this.m_buttonRedirect = new Button(parent, SWT.NONE);
		gridData = new GridData();
		gridData.horizontalSpan = 2;
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		this.m_buttonRedirect.setLayoutData(gridData);
		this.m_buttonRedirect.setText(Messages.getString("refer"));
		this.m_buttonRedirect.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {

				// シェルを取得
				Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();

				// ファイルダイアログを開く
				FileDialog dialog = new FileDialog(shell, SWT.SAVE);
				String extension = "." + "csv";

				String defaultFileName = m_textRedirect.getText();
				if(defaultFileName != null && !"".equals(defaultFileName.trim())){
					dialog.setFileName(defaultFileName.trim());
				}
				dialog.setFilterExtensions(new String[]{"*" + extension});

				String filePath = dialog.open();
				if(filePath != null && !"".equals(filePath)){

					String fileName =dialog.getFileName();
					if(fileName != null && !"".equals(fileName)){
						if(fileName.indexOf(".") == -1){
							filePath += extension;
						}
						m_textRedirect.setText(filePath);
					}
				}
			}
		});

		/*
		 * 属性プロパティシート
		 */
		// ラベル
		label = new Label(parent, SWT.LEFT);
		gridData = new GridData();
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		gridData.horizontalSpan = 15;
		label.setLayoutData(gridData);
		label.setText(Messages.getString("attribute") + " : ");
		// プロパティシート
		TableTree table = new TableTree(parent, SWT.H_SCROLL | SWT.V_SCROLL
				| SWT.FULL_SELECTION | SWT.MULTI | SWT.BORDER);
		gridData = new GridData();
		gridData.horizontalAlignment = GridData.FILL;
		gridData.verticalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		gridData.grabExcessVerticalSpace = true;
		gridData.horizontalSpan = 15;
		table.setLayoutData(gridData);
		this.propertySheet = new PropertySheet(table);

		// プロパティ設定
		if(filterProperty == null){
			filterProperty = new GetEventReportProperty().getProperty();
		}
		this.propertySheet.setInput(filterProperty);
		this.propertySheet.expandAll();

		// ラインを引く
		Label line = new Label(parent, SWT.SEPARATOR | SWT.HORIZONTAL);
		gridData = new GridData();
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		gridData.horizontalSpan = 15;
		line.setLayoutData(gridData);

		// 画面中央に
		Display display = shell.getDisplay();
		shell.setLocation((display.getBounds().width - shell.getSize().x) / 2,
				(display.getBounds().height - shell.getSize().y) / 2);

		//ダイアログのサイズ調整（pack:resize to be its preferred size）
		shell.pack();
		shell.setSize(new Point(shell.getSize().x, sizeY));
	}

	/**
	 * 入力値チェックをします。
	 * 
	 * @return 検証結果
	 */
	@Override
	protected ValidateResult validate() {

		ValidateResult validateResult = null;

		if (this.m_textRedirect.getText() != null
				&& !"".equals((this.m_textRedirect.getText()).trim())) {
			m_redirect = this.m_textRedirect.getText();
		} else {
			validateResult = new ValidateResult();
			validateResult.setValid(false);
			validateResult.setID(Messages.getString("message.hinemos.1"));
			validateResult.setMessage(Messages.getString("message.monitor.44"));
		}
		return validateResult;
	}

	/**
	 * 入力値を保持したプロパティを返します。<BR>
	 * プロパティオブジェクトのコピーを返します。
	 * 
	 * @return プロパティ
	 * 
	 * @see com.clustercontrol.util.PropertyUtil#copy(Property)
	 */
	public Property getInputData() {
		if(filterProperty != null){
			Property copy = PropertyUtil.copy(filterProperty);
			return copy;
		}
		else{
			return null;
		}
	}

	/**
	 * 既存のボタンに加え、クリアボタンを追加します。<BR>
	 * クリアボタンがクリックされた場合、 プロパティを再取得します。
	 * 
	 * @param parent 親のコンポジット（ボタンバー）
	 * 
	 * @see org.eclipse.swt.widgets.Button#addSelectionListener(SelectionListener)
	 */
	@Override
	protected void createButtonsForButtonBar(Composite parent) {
		// クリアボタン
		this.createButton(parent, IDialogConstants.OPEN_ID, Messages
				.getString("clear"), false);
		this.getButton(IDialogConstants.OPEN_ID).addSelectionListener(
				new SelectionAdapter() {
					@Override
					public void widgetSelected(SelectionEvent e) {
						// プロパティ設定
						filterProperty = new GetEventReportProperty().getProperty();
						propertySheet.setInput(filterProperty);
					}
				});

		super.createButtonsForButtonBar(parent);
	}

	/**
	 * ＯＫボタンのテキストを返します。
	 * 
	 * @return ＯＫボタンのテキスト
	 */
	@Override
	protected String getOkButtonText() {
		return Messages.getString("output");
	}

	/**
	 * キャンセルボタンのテキストを返します。
	 * 
	 * @return キャンセルボタンのテキスト
	 */
	@Override
	protected String getCancelButtonText() {
		return Messages.getString("cancel");
	}

	/**
	 * 出力形式を返します。
	 * 
	 * @return 出力形式
	 */
	public int getOutputForm() {
		return m_outputForm;
	}

	/**
	 * 出力先を返します。
	 * 
	 * @return 出力先
	 */
	public String getRedirect() {
		return m_redirect;
	}
}