/*

Copyright (C) 2006 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.monitor.view.action;

import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

import com.clustercontrol.bean.HinemosModuleConstant;
import com.clustercontrol.custom.action.MonitorCustomModifier;
import com.clustercontrol.hinemosagent.action.DeleteAgent;
import com.clustercontrol.http.action.DeleteHttp;
import com.clustercontrol.logfile.action.DeleteLogfile;
import com.clustercontrol.monitor.action.DeleteInterface;
import com.clustercontrol.monitor.composite.MonitorListComposite;
import com.clustercontrol.monitor.run.action.GetMonitorListTableDefine;
import com.clustercontrol.monitor.run.bean.MonitorTypeConstant;
import com.clustercontrol.monitor.view.MonitorListView;
import com.clustercontrol.performance.monitor.action.DeletePerformance;
import com.clustercontrol.ping.action.DeletePing;
import com.clustercontrol.plugin.monitor.IMonitorPlugin;
import com.clustercontrol.plugin.monitor.LoadMonitorPlugin;
import com.clustercontrol.port.action.DeletePort;
import com.clustercontrol.process.action.DeleteProcess;
import com.clustercontrol.snmp.action.DeleteSnmp;
import com.clustercontrol.snmptrap.action.DeleteSnmpTrap;
import com.clustercontrol.sql.action.DeleteSql;
import com.clustercontrol.systemlog.action.DeleteSystemlog;
import com.clustercontrol.util.Messages;
import com.clustercontrol.winevent.action.DeleteWinEvent;
import com.clustercontrol.winservice.action.DeleteWinService;
import com.clustercontrol.ws.monitor.InvalidRole_Exception;

/**
 * 監視[一覧]ビューの削除アクションクラス<BR>
 * 
 * @version 4.0.0
 * @since 4.0.0
 */
public class MonitorDeleteAction implements IViewActionDelegate {

	// ログ
	private static Log m_log = LogFactory.getLog( MonitorDeleteAction.class );

	/** アクションID */
	public static final String ID = "com.clustercontrol.monitor.view.action.MonitorDeleteAction";

	/** ビュー */
	private IViewPart viewPart;


	@Override
	public void run(IAction action) {
		// 選択アイテムの取得
		MonitorListView view = (MonitorListView) this.viewPart.getAdapter(MonitorListView.class);

		MonitorListComposite composite = (MonitorListComposite) view.getListComposite();
		StructuredSelection selection = (StructuredSelection) composite.getTableViewer().getSelection();

		List list = (List) selection.getFirstElement();
		String pluginId = null;
		String monitorId = null;
		int monitorType = 0;
		if(list != null && list.size() > 0){
			pluginId = (String) list.get(GetMonitorListTableDefine.MONITOR_TYPE_ID);
			monitorId = (String) list.get(GetMonitorListTableDefine.MONITOR_ID);
			monitorType = MonitorTypeConstant.stringToType((String) list.get(GetMonitorListTableDefine.MONITOR_TYPE));
		}

		// 選択アイテムがある場合に、削除処理を呼び出す
		if(pluginId != null && monitorId != null){
			// 削除を実行してよいかの確認ダイアログの表示
			String[] args = { monitorId };
			if (!MessageDialog.openConfirm(
					null,
					Messages.getString("confirmed"),
					Messages.getString("message.monitor.39", args))) {

				// OKが押されない場合は終了
				return;
			}

			DeleteInterface deleteInterface = null;
			if (pluginId.equals(HinemosModuleConstant.MONITOR_AGENT)) {
				deleteInterface = new DeleteAgent();
			} else if (pluginId.equals(HinemosModuleConstant.MONITOR_HTTP)) {
				deleteInterface = new DeleteHttp();
			} else if (pluginId.equals(HinemosModuleConstant.MONITOR_PERFORMANCE)) {
				deleteInterface = new DeletePerformance();
			} else if (pluginId.equals(HinemosModuleConstant.MONITOR_PING)) {
				deleteInterface = new DeletePing();
			} else if (pluginId.equals(HinemosModuleConstant.MONITOR_PORT)) {
				deleteInterface = new DeletePort();
			} else if (pluginId.equals(HinemosModuleConstant.MONITOR_PROCESS)) {
				deleteInterface = new DeleteProcess();
			} else if (pluginId.equals(HinemosModuleConstant.MONITOR_SNMP)) {
				deleteInterface = new DeleteSnmp();
			} else if (pluginId.equals(HinemosModuleConstant.MONITOR_SQL)) {
				deleteInterface = new DeleteSql();
			} else if (pluginId.equals(HinemosModuleConstant.MONITOR_SYSTEMLOG)) {
				deleteInterface = new DeleteSystemlog();
			} else if (pluginId.equals(HinemosModuleConstant.MONITOR_LOGFILE)) {
				deleteInterface = new DeleteLogfile();
			} else if (pluginId.equals(HinemosModuleConstant.MONITOR_CUSTOM)) {
				deleteInterface = new MonitorCustomModifier();
			} else if (pluginId.equals(HinemosModuleConstant.MONITOR_SNMPTRAP)) {
				deleteInterface = new DeleteSnmpTrap();
			} else if (pluginId.equals(HinemosModuleConstant.MONITOR_WINSERVICE)) {
				deleteInterface = new DeleteWinService();
			} else if (pluginId.equals(HinemosModuleConstant.MONITOR_WINEVENT)) {
				deleteInterface = new DeleteWinEvent();
			} else {
				for(IMonitorPlugin extensionMonitor: LoadMonitorPlugin.getExtensionMonitorList()){
					if(pluginId.equals(extensionMonitor.getMonitorPluginId())){
						deleteInterface = extensionMonitor.getDeleteMonitorClassObject();
					}
				}

				if(deleteInterface == null){
					m_log.warn("unknown pluginId " + pluginId);
					return;
				}
			}
			String errMessage = "";
			boolean result = false;
			try {
				result = deleteInterface.delete(monitorId);

			} catch(Exception e) {
				if (e instanceof InvalidRole_Exception) {
					// アクセス権なしの場合、エラーダイアログを表示する
					MessageDialog.openInformation(null, Messages.getString("message"),
							Messages.getString("message.accesscontrol.16"));
				} else {
					errMessage = ", " + e.getMessage();
				}
			}
			if(result){
				MessageDialog.openInformation(
						null,
						Messages.getString("successful"),
						Messages.getString("message.monitor.37", args));
				view.update();
			} else {
				MessageDialog.openError(
						null,
						Messages.getString("failed"),
						Messages.getString("message.monitor.38", args) + errMessage);
			}
		}
	}

	@Override
	public void selectionChanged(IAction action, ISelection selection) {
		// TODO Auto-generated method stub

	}

	@Override
	public void init(IViewPart viewPart) {
		this.viewPart = viewPart;
	}

}
