/*

Copyright (C) 2012 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.plugin.impl;

import java.util.Date;
import java.util.HashSet;
import java.util.Set;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.commons.util.HinemosProperties;
import com.clustercontrol.fault.HinemosUnknown;
import com.clustercontrol.plugin.api.HinemosPlugin;
import com.clustercontrol.plugin.impl.SchedulerPlugin.SchedulerType;
import com.clustercontrol.sharedtable.SharedTable;
import com.clustercontrol.sharedtable.session.CheckJobBean;

/**
 * 各種機能で共有される情報を保持するSharedTableを管理するプラグイン.
 */
public class SharedTablePlugin implements HinemosPlugin {

	public static final Log log = LogFactory.getLog(SharedTablePlugin.class);

	private static SharedTable _sharedTable = SharedTable.getInstance();

	/** 情報の保持期間(GC対象とするかどうかの判断基準) */
	public static final long _keepAliveSec;
	public static final long _keepAliveSecDefault = 60000L;

	/** 古い情報のGCなどを行うメンテナンス処理の定義 */
	public static final String _checkJobName = "CHECK_JOB";
	public static final String _checkJobGroup = "SHAREDTABLE";
	public static final String _checkJobCronExpression = "34 */10 * * * ? *"; // チェックジョブの起動条件


	static {
		String keepAliveSecStr = HinemosProperties.getProperty("plugin.sharedtable.keepalive" , "60000");
		long keepAliveSec = _keepAliveSecDefault;
		try {
			keepAliveSec = Long.parseLong(keepAliveSecStr);
		} catch (NumberFormatException e) {
			log.warn("parameter is not long. (plugin.sharedtable.keepalive = " + keepAliveSecStr + ")", e);
		}
		_keepAliveSec = keepAliveSec;
	}

	@Override
	public Set<String> getDependency() {
		Set<String> dependency = new HashSet<String>();
		dependency.add(Log4jReloadPlugin.class.getName());
		return dependency;
	}

	@Override
	public void create() {
		_sharedTable.setKeepAlive(_keepAliveSec);

	}

	@Override
	public void activate() {
		schedulerCheckJob();
	}

	@Override
	public void deactivate() {
		// TODO Auto-generated method stub

	}

	@Override
	public void destroy() {
		// do nothing
	}

	public static SharedTable getSharedTable() {
		return _sharedTable;
	}

	private void schedulerCheckJob() {
		Object[] jdArgs = new Object[0];
		@SuppressWarnings("rawtypes")
		Class[] jdArgsType = new Class[0];

		try {
			// SimpleTrigger でジョブをスケジューリング登録
			// 監視も収集も無効の場合、登録後にポーズするようにスケジュール
			SchedulerPlugin.scheduleCronJob(SchedulerType.RAM, _checkJobName, _checkJobGroup, new Date(),
					_checkJobCronExpression, true, CheckJobBean.class.getName(), CheckJobBean.METHOD_NAME,
					jdArgsType, jdArgs);

		} catch (HinemosUnknown e) {
			log.warn(e.getMessage(), e);
		}
	}

}
