/*

Copyright (C) 2006 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.collectiverun.factory;

import javax.persistence.EntityManager;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.collectiverun.bean.CommandInfo;
import com.clustercontrol.collectiverun.bean.CommandParameterInfo;
import com.clustercontrol.collectiverun.bean.ItemConstant;
import com.clustercontrol.collectiverun.bean.ItemInfo;
import com.clustercontrol.collectiverun.bean.ParameterInfo;
import com.clustercontrol.collectiverun.bean.ParameterSelectInfo;
import com.clustercontrol.collectiverun.bean.TypeInfo;
import com.clustercontrol.collectiverun.model.CrunCmdMstEntity;
import com.clustercontrol.collectiverun.model.CrunCmdParamMstEntity;
import com.clustercontrol.collectiverun.model.CrunParamMstEntity;
import com.clustercontrol.collectiverun.model.CrunParamSelectMstEntity;
import com.clustercontrol.collectiverun.model.CrunTypeMstEntity;
import com.clustercontrol.collectiverun.util.QueryUtil;
import com.clustercontrol.commons.util.JpaTransactionManager;
import com.clustercontrol.fault.CollectiveRunNotFound;

/**
 * マスタ削除クラス
 *
 * @version 2.1.0
 * @since 2.1.0
 */
public class DeleteMaster {
	private static Log m_log = LogFactory.getLog( DeleteMaster.class );

	/**
	 * 一括制御マスタ情報削除
	 * 
	 * @param info
	 * @throws CollectiveRunNotFound
	 */
	public void delete(ItemInfo info, ItemInfo parentInfo) throws CollectiveRunNotFound {

		if(info == null || parentInfo == null){
			return;
		}

		//cast出来ない場合はreturnする
		if (!(info instanceof TypeInfo)
				&& !(info instanceof CommandInfo)
				&& !(info instanceof CommandParameterInfo)
				&& !(info instanceof ParameterInfo)
				&& !(info instanceof ParameterSelectInfo)
				&& !(parentInfo instanceof CommandInfo)
				&& !(parentInfo instanceof TypeInfo))
			return;

		EntityManager em = new JpaTransactionManager().getEntityManager();

		if(info.getType() == ItemConstant.TYPE_TYPE){
			//IDで種別を検索し取得
			CrunTypeMstEntity type = QueryUtil.getCrunTypeMstPK(((TypeInfo)info).getId());

			//種別削除
			em.remove(type);
		}
		else if(info.getType() == ItemConstant.TYPE_COMMAND){
			//IDでコマンドを検索し取得
			CrunCmdMstEntity cmd = QueryUtil.getCrunCmdMstPK(((CommandInfo)info).getId());

			// コマンド情報削除
			cmd.unchain();	// 削除前処理
			em.remove(cmd);
		}
		else if(info.getType() == ItemConstant.TYPE_COMMAND_PARAMETER){
			//IDでコマンドパラメータを検索し取得
			CrunCmdParamMstEntity cmdParam = QueryUtil.getCrunCmdParamMstPK(
					((CommandInfo)parentInfo).getId(),
					((CommandParameterInfo)info).getId());

			// コマンドパラメータ削除
			cmdParam.unchain();	// 削除前処理
			em.remove(cmdParam);
		}
		else if(info.getType() == ItemConstant.TYPE_PARAMETER){
			//IDでパラメータを検索し取得
			CrunParamMstEntity param = QueryUtil.getCrunParamMstPK(((ParameterInfo)info).getId());

			//パラメータ削除
			em.remove(param);
		}
		else if(info.getType() == ItemConstant.TYPE_SELECT_ITEM){
			//IDでパラメータ選択肢を検索し取得
			CrunParamSelectMstEntity select = QueryUtil.getCrunParamSelectMstPK(
					((ParameterSelectInfo)info).getId(),
					Integer.valueOf(((ParameterSelectInfo)info).getOrderNo()));

			//パラメータ選択肢削除
			select.unchain();	// 削除前処理
			em.remove(select);
		}
	}
}
