package com.clustercontrol.collectiverun.model;

import java.io.Serializable;
import java.util.Arrays;

import javax.persistence.*;

/**
 * The primary key class for the cc_crun_end_mst database table.
 * 
 */
@Embeddable
public class CrunEndMstEntityPK implements Serializable {
	//default serial version id, required for serializable classes.
	private static final long serialVersionUID = 1L;
	private String commandId;
	private Integer endStatus;

	public CrunEndMstEntityPK() {
	}

	public CrunEndMstEntityPK(String commandId, Integer endStatus) {
		this.setCommandId(commandId);
		this.setEndStatus(endStatus);
	}

	@Column(name="command_id")
	public String getCommandId() {
		return this.commandId;
	}
	public void setCommandId(String commandId) {
		this.commandId = commandId;
	}

	@Column(name="end_status")
	public Integer getEndStatus() {
		return this.endStatus;
	}
	public void setEndStatus(Integer endStatus) {
		this.endStatus = endStatus;
	}

	@Override
	public boolean equals(Object other) {
		if (this == other) {
			return true;
		}
		if (!(other instanceof CrunEndMstEntityPK)) {
			return false;
		}
		CrunEndMstEntityPK castOther = (CrunEndMstEntityPK)other;
		return
				this.commandId.equals(castOther.commandId)
				&& this.endStatus.equals(castOther.endStatus);
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int hash = 17;
		hash = hash * prime + this.commandId.hashCode();
		hash = hash * prime + this.endStatus.hashCode();

		return hash;
	}

	@Override
	public String toString() {
		String[] names = {
				"commandId",
				"endStatus"
		};
		String[] values = {
				this.commandId,
				this.endStatus.toString()
		};
		return Arrays.toString(names) + " = " + Arrays.toString(values);
	}
}