package com.clustercontrol.commons.util;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CacheManagerFactory {
	
	public static final Log _log = LogFactory.getLog(CacheManagerFactory.class);
	
	private static final CacheManagerFactory _instance = new CacheManagerFactory();
	private static final AbstractCacheManager _cacheManager;
	
	static {
		String className = null;
		Class<? extends AbstractCacheManager> clazz = LocalCacheManager.class;
		AbstractCacheManager cacheManager = new LocalCacheManager();
		try {
			className = System.getProperty("hinemos.cachemanager.class", LocalCacheManager.class.getName());
			clazz = (Class<? extends AbstractCacheManager>)Class.forName(className);
			
			if (clazz != null) {
				cacheManager = clazz.newInstance();
			}
		} catch (Exception e) {
			_log.warn("cache manager " + className + " not found.", e);
		} finally {
			_cacheManager = cacheManager;
			_log.info("initialized cache manager : " + _cacheManager.getClass().getName());
		}
	}
	
	private CacheManagerFactory() { }
	
	public static CacheManagerFactory instance() {
		return _instance;
	}
	
	public AbstractCacheManager create() {
		return _cacheManager;
	}
	
}
