/*
Copyright (C) 2015 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.xcloud.aws.ui.dialogs;

import static com.clustercontrol.xcloud.aws.common.AWSConstants.IOPS_VALUE;
import static com.clustercontrol.xcloud.aws.common.AWSConstants.bundle_messages;

import java.util.List;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.swt.SWTResourceManager;

import com.clustercontrol.ws.xcloud.AvailabilityZone;
import com.clustercontrol.ws.xcloud.Snapshot;
import com.clustercontrol.xcloud.aws.common.AWSStringConstants;
import com.clustercontrol.xcloud.common.CloudStringConstants;
import com.clustercontrol.xcloud.model.cloud.ILocation;
import com.clustercontrol.xcloud.ui.dialogs.IDialogConstants;
import com.clustercontrol.xcloud.util.ControlUtil;

public class CreateStorageDialog extends Dialog implements CloudStringConstants, AWSStringConstants {
	public interface DialogDataFactory {
		DialogData createDialogData();
	}
	public interface DialogData {
		String getName();
		void setName(String value);
		String getAvailabilityZone();
		void setAvailabilityZone(String value);
		Integer getIops();
		void setIops(Integer value);
		String getSnapshotId();
		void setSnapshotId(String value);
		Integer getSize();
		void setSize(Integer value);
		String getType();
		void setType(String value);
	}
	
	protected VerifyListener numberVelifylistener = (new VerifyListener() {
		public void verifyText(VerifyEvent e) {
			try {
				Text text = (Text)e.getSource();
				String t = text.getText().substring(0, e.start) + e.text + text.getText().substring(e.end);
				if (t.length() != 0) {
					Integer.valueOf(t);
				}
			} catch(Exception e1) {
				e.doit = false;
			}
		}
	});

	protected Text txtVolumeName;
	protected Text txtSize;
	protected Combo cmbAvailabilityZone;
	protected Combo cmbVolumeType;
	protected Text txtIops;
	protected Combo cmbSnapshot;
	protected Button btnNewButton;

	protected AWSResourceProvider provider;
	
	protected ILocation location;
	protected String dlgTitle;
	
	protected DialogDataFactory factory;
	protected DialogData output;

	
	protected boolean all = false;

	/**
	 * Create the dialog.
	 * @param parentShell
	 */
	public CreateStorageDialog(Shell parentShell, ILocation location, String dlgTitle, AWSResourceProvider provider) {
		super(parentShell);
		this.location = location;
		this.provider = provider;
		this.dlgTitle = dlgTitle;
	}
	
	public void setDialogDataFactory(DialogDataFactory factory) {
		this.factory = factory;
	}
	
	public void setDialogData(DialogData data) {
		this.output = data;
	}

	/**
	 * Create contents of the dialog.
	 * @param parent
	 */
	@Override
	protected Control createDialogArea(Composite parent) {
		Composite area = (Composite) super.createDialogArea(parent);
		Composite container = new Composite(area, SWT.NONE);
		container.setBackground(SWTResourceManager.getColor(SWT.COLOR_WIDGET_BACKGROUND));
		GridLayout gl_container = new GridLayout(3, false);
		gl_container.horizontalSpacing = 15;
		container.setLayout(gl_container);
		GridData gd_container = new GridData(GridData.FILL_BOTH);
		gd_container.widthHint = 614;
		container.setLayoutData(gd_container);
		
		Label lblNewLabel = new Label(container, SWT.RIGHT);
		lblNewLabel.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		lblNewLabel.setText(strManager + strSeparator);
		
		Label lblNewLabel_4 = new Label(container, SWT.BORDER);
		lblNewLabel_4.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, false, 2, 1));
		lblNewLabel_4.setText(location.getCloudScope().getCloudScopes().getHinemosManager().getManagerName());
		
		Label lblNewLabel_1 = new Label(container, SWT.RIGHT);
		lblNewLabel_1.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		lblNewLabel_1.setText(strCloudScope + strSeparator);
		
		Label lblNewLabel_5 = new Label(container, SWT.BORDER);
		lblNewLabel_5.setLayoutData(new GridData(SWT.FILL, SWT.FILL, false, false, 2, 1));
		lblNewLabel_5.setText(String.format("%s (%s)", location.getCloudScope().getName(), location.getCloudScope().getId()));
		
		Label lblVolumeName = new Label(container, SWT.NONE);
		lblVolumeName.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
		lblVolumeName.setText(strStorageName + strSeparator);
		
		txtVolumeName = new Text(container, SWT.BORDER);
		txtVolumeName.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 2, 1));
		if (getOutput().getName() != null)
			txtVolumeName.setText(getOutput().getName());
		
		Label lblSize = new Label(container, SWT.NONE);
		lblSize.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
		lblSize.setText(strSizeGib + strSeparator);
		
		txtSize = new Text(container, SWT.BORDER);
		GridData gd_size = new GridData(SWT.FILL, SWT.CENTER, true, false, 2, 1);
		gd_size.widthHint = 146;
		txtSize.setLayoutData(gd_size);
		txtSize.addVerifyListener(numberVelifylistener);
		txtSize.addModifyListener(new ModifyListener() {
			public void modifyText(ModifyEvent e) {
				checkFinished();
			}
		});
		if (getOutput().getSize() != null)
			txtSize.setText(getOutput().getSize().toString());
		
		Label lblAvailabilityzone = new Label(container, SWT.NONE);
		lblAvailabilityzone.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
		lblAvailabilityzone.setText(strAvailabilityZone + strSeparator);
		
		cmbAvailabilityZone = new Combo(container, SWT.READ_ONLY);
		cmbAvailabilityZone.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 2, 1));
		for (AvailabilityZone zone: provider.getZone()) {
			cmbAvailabilityZone.add(zone.getZoneName());
		}
		if (getOutput().getAvailabilityZone() != null) {
			for (String volumeType: cmbAvailabilityZone.getItems()) {
				if (getOutput().getAvailabilityZone().equals(volumeType)) {
					cmbAvailabilityZone.setText(volumeType);
				}
			}
		} else if (cmbAvailabilityZone.getItems().length > 0)
			cmbAvailabilityZone.select(0);
		
		Label lblSnapshot = new Label(container, SWT.NONE);
		lblSnapshot.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
		lblSnapshot.setText(strSnapshot + strSeparator);
		
		cmbSnapshot = new Combo(container, SWT.READ_ONLY);
		GridData gd_snapshot = new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1);
		gd_snapshot.widthHint = 570;
		cmbSnapshot.setLayoutData(gd_snapshot);
		cmbSnapshot.add("--- No Snapshot ---");
		
		List<Snapshot> snapshots = provider.getSnapshots(all);
		for (Snapshot s: snapshots) {
			String snapshotItem = s.getId() + " -- " + s.getDescription();
			cmbSnapshot.add(snapshotItem);
			cmbSnapshot.setData(snapshotItem, s.getId());
		}
		if (cmbSnapshot.getItems().length > 0)
			cmbSnapshot.select(0);
		
		if (getOutput().getSnapshotId() != null) {
			for (String snapshotItem: cmbSnapshot.getItems()) {
				String snapshotId = (String)cmbSnapshot.getData(snapshotItem);
				
				if (snapshotId != null && snapshotId.equals(getOutput().getSnapshotId())) {
					cmbSnapshot.setText(snapshotItem);
				}
			}
		}
		
		btnNewButton = new Button(container, SWT.CHECK);
		btnNewButton.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				all = btnNewButton.getSelection();
				
				cmbSnapshot.removeAll();
				
				cmbSnapshot.add("--- No Snapshot ---");
				
				List<Snapshot> snapshots = provider.getSnapshots(all);
				for (Snapshot s: snapshots) {
					String snapshotItem = s.getId() + " -- " + s.getDescription();
					cmbSnapshot.add(snapshotItem);
					cmbSnapshot.setData(snapshotItem, s);
				}
				cmbSnapshot.select(0);
			}
		});
		
		GridData gd_btnNewButton = new GridData(SWT.FILL, SWT.FILL, false, false, 1, 1);
		gd_btnNewButton.widthHint = 48;
		btnNewButton.setLayoutData(gd_btnNewButton);
		btnNewButton.setText(strAll);
		
		Label lblVolumeType = new Label(container, SWT.NONE);
		lblVolumeType.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
		lblVolumeType.setText(strType + strSeparator);
		
		cmbVolumeType = new Combo(container, SWT.READ_ONLY);
		GridData gd_volumeType = new GridData(SWT.FILL, SWT.CENTER, true, false, 2, 1);
		gd_volumeType.widthHint = 220;
		cmbVolumeType.setLayoutData(gd_volumeType);
		cmbVolumeType.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				txtIops.setEnabled(cmbVolumeType.getText().equals(IOPS_VALUE));
				checkFinished();
			}
		});
		for (String volumeType: provider.getVolumeType()) {
			cmbVolumeType.add(volumeType);
		}
		if (cmbVolumeType.getItems().length > 0)
			cmbVolumeType.select(0);
		
		if (getOutput().getType() != null) {
			for (String volumeType: cmbVolumeType.getItems()) {
				if (getOutput().getType().equals(volumeType)) {
					cmbVolumeType.setText(volumeType);
				}
			}
		} 
		
		Label lblIops = new Label(container, SWT.NONE);
		lblIops.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
		lblIops.setText("IOPS");
		
		txtIops = new Text(container, SWT.BORDER);
		txtIops.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 2, 1));
		txtIops.addVerifyListener(numberVelifylistener);
		txtIops.setEnabled(cmbVolumeType.getText().equals(IOPS_VALUE));
		if (getOutput().getIops() != null)
			txtIops.setText(getOutput().getIops().toString());
		txtIops.addModifyListener(new ModifyListener() {
			public void modifyText(ModifyEvent e) {
				checkFinished();
			}
		});

		ControlUtil.setRequired(new Control[]{txtSize, txtIops});

		getShell().getDisplay().asyncExec(new Runnable() {
			@Override
			public void run() {
				checkFinished();
			}
		});
		
		return area;
	}

	/**
	 * Create contents of the button bar.
	 * @param parent
	 */
	@Override
	protected void createButtonsForButtonBar(Composite parent) {
		createButton(parent, IDialogConstants.OK_ID, IDialogConstants.OK_LABEL,
				false);
		createButton(parent, IDialogConstants.CANCEL_ID,
				IDialogConstants.CANCEL_LABEL, false);
	}

	/**
	 * Return the initial size of the dialog.
	 */
	@Override
	protected Point getInitialSize() {
		return new Point(444, 332);
	}

	@Override
	protected void okPressed() {
		output.setName(txtVolumeName.getText());
		output.setSize(Integer.parseInt(txtSize.getText()));
		output.setAvailabilityZone(cmbAvailabilityZone.getText());
		output.setSnapshotId((String)cmbSnapshot.getData(cmbSnapshot.getText()));
		output.setType((String)cmbVolumeType.getData(cmbVolumeType.getText()));
		if (bundle_messages.getString(IOPS_VALUE).equals(cmbVolumeType.getText())) {
			output.setIops("".equals(txtIops.getText()) || txtIops.getText() == null ? null: Integer.parseInt(txtIops.getText()));
		}
		super.okPressed();
	}

	@Override
	protected void configureShell(Shell newShell) {
		super.configureShell(newShell);
		newShell.setText(dlgTitle);
	}

	public DialogData getOutput() {
		if (this.output == null)
			output = factory.createDialogData();
		return output;
	}
	
	protected void checkFinished() {
		Button okButton = getButton(IDialogConstants.OK_ID);
		if (okButton == null)
			return;
			
		if (txtSize != null && !txtSize.getText().isEmpty() &&
			cmbVolumeType != null && (!cmbVolumeType.getText().equals(IOPS_VALUE) || (txtIops != null && !txtIops.getText().isEmpty()))
			) {
			getButton(IDialogConstants.OK_ID).setEnabled(true);
		} else {
			getButton(IDialogConstants.OK_ID).setEnabled(false);
		}
	}
}
