package com.clustercontrol.xcloud.aws.ui.dialogs;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;

import com.clustercontrol.ws.xcloud.Tag;
import com.clustercontrol.xcloud.aws.common.AWSStringConstants;
import com.clustercontrol.xcloud.common.CloudStringConstants;
import com.clustercontrol.xcloud.model.CloudModelException;
import com.clustercontrol.xcloud.platform.PlatformDependent;
import com.clustercontrol.xcloud.ui.dialogs.IDialogConstants;
import com.clustercontrol.xcloud.ui.dialogs.TagEditor;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;

public class InstanceDetailDialog extends Dialog implements CloudStringConstants, AWSStringConstants {
	private static final String IOPS_VALUE = "io1";
	
	private AWSResourceProvider provider;
	private CreateInstanceDialog.DialogData input;
	private List<Tag> editingTags;
	
	private VerifyListener numberVelifylistener = (new VerifyListener() {
		public void verifyText(VerifyEvent e) {
			try {
				Text text = (Text)e.getSource();
				String t = text.getText().substring(0, e.start) + e.text + text.getText().substring(e.end);
				if (t.length() != 0) {
					Integer.valueOf(t);
				}
			} catch(Exception e1) {
				e.doit = false;
			}
		}
	});

	private Table table;
	private Text text_2;
	private Text text_3;
	
	private Combo combo_2;
	private Combo combo_1;
	
	private Button btnNewButton_4;
	private Button btnNewButton;
	private Button btnNewButton_1;
	private Button btnNewButton_2;
	private Button btnNewButton_3;
	private Text text_1;
	
	private String dlgTitle;

	/**
	 * Create the dialog.
	 * @param parentShell
	 */
	public InstanceDetailDialog(Shell parentShell, String dlgTitle, CreateInstanceDialog.DialogData input, AWSResourceProvider provider) {
		super(parentShell);
		this.input = input;
		this.provider = provider;
		this.dlgTitle = dlgTitle;
		
		try {
			ObjectMapper objectMapper = new ObjectMapper();
			ObjectWriter writer = objectMapper.writer();
			ObjectReader reader = objectMapper.reader(objectMapper.getTypeFactory().constructCollectionType(List.class, Tag.class));
			String copy = writer.writeValueAsString(input.getTags());
			editingTags = reader.readValue(copy);
		} catch (IOException e) {
			throw new CloudModelException(e);
		}
	}

	/**
	 * Create contents of the dialog.
	 * @param parent
	 */
	@Override
	protected Control createDialogArea(Composite parent) {
		Composite container = (Composite) super.createDialogArea(parent);
		GridLayout gl_container = new GridLayout(1, false);
		gl_container.marginWidth = 18;
		gl_container.marginHeight = 13;
		container.setLayout(gl_container);
		
		List<Control> labels = new ArrayList<>();
		List<Group> groups = new ArrayList<>();

		Group group = new Group(container, SWT.NONE);
		group.setText(strNetwork);
		group.setLayoutData(new GridData(SWT.FILL, SWT.FILL, false, false, 1, 1));
		group.setLayout(new GridLayout(3, false));
		groups.add(group);
		
		Label lblNewLabel_6 = new Label(group, SWT.NONE);
		lblNewLabel_6.setAlignment(SWT.RIGHT);
		lblNewLabel_6.setText(strPublicIpAutoAssigne + strSeparator);
		labels.add(lblNewLabel_6);
		new Label(group, SWT.NONE);
		
		btnNewButton_4 = new Button(group, SWT.CHECK);
		btnNewButton_4.setSelection(
			(input.isAssociatePublicIpAddress() == null || !input.isAssociatePublicIpAddress()) ? false: true);
		
		Group group_1 = new Group(container, SWT.NONE);
		group_1.setText(strStorage + strSeparator);
		group_1.setLayoutData(new GridData(SWT.FILL, SWT.FILL, false, false, 1, 1));
		group_1.setLayout(new GridLayout(3, false));
		groups.add(group_1);
		
		Label lblNewLabel_2 = new Label(group_1, SWT.NONE);
		lblNewLabel_2.setAlignment(SWT.RIGHT);
		lblNewLabel_2.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		lblNewLabel_2.setText(strSizeGib + strSeparator);
		labels.add(lblNewLabel_2);
		
		text_2 = new Text(group_1, SWT.BORDER);
		text_2.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 2, 1));
		text_2.addVerifyListener(numberVelifylistener);
		if (input.getVolumeSize() != null)
			text_2.setText(input.getVolumeSize().toString());
		
		Label lblNewLabel_3 = new Label(group_1, SWT.NONE);
		lblNewLabel_3.setAlignment(SWT.RIGHT);
		lblNewLabel_3.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		lblNewLabel_3.setText(strVolumeType + strSeparator);
		labels.add(lblNewLabel_3);
		
		combo_2 = new Combo(group_1, SWT.READ_ONLY);
		combo_2.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				text_3.setEnabled(combo_2.getText().equals(IOPS_VALUE));
			}
		});
		combo_2.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 2, 1));
		
		for (String volumeType: provider.getVolumeType()) {
			combo_2.add(volumeType);
		}
		
		if (input.getVolumeType() != null) {
			for (String volumeType: combo_2.getItems()) {
				if (input.getVolumeType().equals(volumeType)) {
					combo_2.setText(volumeType);
				}
			}
		} else if (combo_2.getItems().length > 0)
			combo_2.select(0);
		
		Label lblNewLabel_4 = new Label(group_1, SWT.NONE);
		lblNewLabel_4.setAlignment(SWT.RIGHT);
		lblNewLabel_4.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		lblNewLabel_4.setText(strIops + strSeparator);
		labels.add(lblNewLabel_4);
		
		text_3 = new Text(group_1, SWT.BORDER);
		text_3.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 2, 1));
		text_3.addVerifyListener(numberVelifylistener);
		text_3.setEnabled(combo_2.getText().equals(IOPS_VALUE));
		if (input.getIops() != null)
			text_3.setText(input.getIops().toString());
		
		Label lblNewLabel_5 = new Label(group_1, SWT.NONE);
		lblNewLabel_5.setAlignment(SWT.RIGHT);
		lblNewLabel_5.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		lblNewLabel_5.setText(strDeleteOnTerminate + strSeparator);
		new Label(group_1, SWT.NONE);
		labels.add(lblNewLabel_5);
		
		btnNewButton = new Button(group_1, SWT.CHECK);
		btnNewButton.setSelection(
				(input.isDeleteOnTermination() == null ||
					!input.isDeleteOnTermination()) ? false: true);
		
		Group group_2 = new Group(container, SWT.NONE);
		group_2.setText(strDetailSettings);
		group_2.setLayoutData(new GridData(SWT.FILL, SWT.FILL, false, false, 1, 1));
		group_2.setLayout(new GridLayout(3, false));
		groups.add(group_2);
		
		Label lblNewLabel = new Label(group_2, SWT.NONE);
		lblNewLabel.setAlignment(SWT.RIGHT);
		lblNewLabel.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		lblNewLabel.setText(strShutdownBehaviour + strSeparator);
		labels.add(lblNewLabel);
		
		combo_1 = new Combo(group_2, SWT.READ_ONLY);
		combo_1.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 2, 1));
		
		for (String bihaviorType: provider.getInstanceInitiatedShutdownBehaviorTypes()) {
			combo_1.add(bihaviorType);
		}
		if (input.getInstanceInitiatedShutdownBehavior() != null) {
			for (String bihaviorType: combo_1.getItems()) {
				if (input.getInstanceInitiatedShutdownBehavior().equals(bihaviorType)) {
					combo_1.setText(bihaviorType);
				}
			}
		} else if (combo_1.getItems().length > 0)
			combo_1.select(0);
		
		Label label_2 = new Label(group_2, SWT.NONE);
		label_2.setAlignment(SWT.RIGHT);
		label_2.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		label_2.setText(strDisableApiTermination + strSeparator);
		new Label(group_2, SWT.NONE);
		labels.add(label_2);
		
		btnNewButton_1 = new Button(group_2, SWT.CHECK);
		btnNewButton_1.setSelection(
				(input.isDisableApiTermination() == null || !input.isDisableApiTermination()) ? false: true);
		
		Label label_4 = new Label(group_2, SWT.NONE);
		label_4.setAlignment(SWT.RIGHT);
		label_4.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		label_4.setText(strDetailedMonitoring + strSeparator);
		new Label(group_2, SWT.NONE);
		labels.add(label_4);
		
		btnNewButton_2 = new Button(group_2, SWT.CHECK);
		btnNewButton_2.setSelection(
				(input.isMonitoring() == null || !input.isMonitoring()) ? false: true);
		
		Label lblNewLabel_1 = new Label(group_2, SWT.NONE);
		lblNewLabel_1.setAlignment(SWT.RIGHT);
		lblNewLabel_1.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		lblNewLabel_1.setText(strEbsOptimized + strSeparator);
		new Label(group_2, SWT.NONE);
		labels.add(lblNewLabel_1);
		
		btnNewButton_3 = new Button(group_2, SWT.CHECK);
		btnNewButton_3.setSelection(
				(input.isEbsOptimized() == null || !input.isEbsOptimized()) ? false: true);
		
		Group group_4 = new Group(container, SWT.NONE);
		group_4.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		group_4.setText(strAttribute);
		group_4.setLayout(new GridLayout(6, false));
		groups.add(group_4);
		
		Label lblNewLabel_8 = new Label(group_4, SWT.NONE);
		lblNewLabel_8.setAlignment(SWT.RIGHT);
		lblNewLabel_8.setLayoutData(new GridData(SWT.FILL, SWT.FILL, false, false, 1, 1));
		lblNewLabel_8.setText(strMemo + strSeparator);
//		labels.add(lblNewLabel_8);
		
		text_1 = new Text(group_4, SWT.BORDER | SWT.WRAP);
		GridData gd_text_1 = new GridData(SWT.FILL, SWT.FILL, true, false, 5, 1);
		gd_text_1.heightHint = 53;
		gd_text_1.widthHint = 331;
		text_1.setLayoutData(gd_text_1);
		
		if (input.getMemo() != null)
			text_1.setText(input.getMemo());
		
		Label lblNewLabel_7 = new Label(group_4, SWT.NONE);
		lblNewLabel_7.setLayoutData(new GridData(SWT.FILL, SWT.FILL, false, false, 1, 1));
		lblNewLabel_7.setAlignment(SWT.RIGHT);
		lblNewLabel_7.setText(strTag + strSeparator);
//		labels.add(lblNewLabel_7);
		
		TableViewer tableViewer = new TableViewer(group_4, SWT.BORDER | SWT.FULL_SELECTION);
		table = tableViewer.getTable();
		table.setLinesVisible(true);
		table.setHeaderVisible(true);
		GridData gd_table = new GridData(SWT.FILL, SWT.FILL, true, true, 5, 1);
		gd_table.widthHint = 302;
		gd_table.heightHint = 95;
		table.setLayoutData(gd_table);
		
		Composite composite = new Composite(group_4, SWT.NONE);
		composite.setLayoutData(new GridData(SWT.FILL, SWT.FILL, false, false, 6, 1));
		
		Button button_1 = new Button(composite, SWT.NONE);
		button_1.setBounds(345, 0, 80, 25);
		button_1.setText(strDelete);
		
		Button button = new Button(composite, SWT.NONE);
		button.setBounds(259, 0, 80, 25);
		button.setText(strAdd);
		
		GridData gd_btnNewButton_1 = new GridData(SWT.LEFT, SWT.CENTER, false, false, 1, 1);
		gd_btnNewButton_1.widthHint = 100;
		btnNewButton_1.setLayoutData(gd_btnNewButton_1);
		
		new TagEditor(tableViewer, new int[]{60, 155, 155}, button, button_1, editingTags);

		if (!PlatformDependent.getPlatformDependent().isRapPlatfome()) {
			// 項目名の幅をグループ間で一致させる。
			container.layout();
			int maxWidth = 0;
			for (Control l: labels) {
				Point p = l.getSize();
				maxWidth = Math.max(maxWidth, p.x);
			}
			for (Control l: labels) {
				((GridData)l.getLayoutData()).widthHint = maxWidth;
			}
			for (Group g: groups) {
				g.layout(true);
			}
		}

		return container;
	}

	@Override
	protected void okPressed() {
		input.setAssociatePublicIpAddress(btnNewButton_4.getSelection());
		
		try {
			Integer size = Integer.valueOf(text_2.getText());
			input.setVolumeSize(size);
		} catch(NumberFormatException e) {
			input.setVolumeSize(null);
		}
		
		String volumeType = combo_2.getText();
		if (volumeType == null || volumeType.isEmpty()) {
			input.setVolumeType(volumeType);
		} else {
			input.setVolumeType(volumeType);
		}
		
		try {
			Integer size = Integer.valueOf(text_3.getText());
			input.setIops(size);
		} catch(NumberFormatException e) {
			input.setIops(null);
		}

		input.setDeleteOnTermination(btnNewButton.getSelection());
		
		String behavior = combo_1.getText();
		if (behavior == null || behavior.isEmpty()) {
			input.setInstanceInitiatedShutdownBehavior(null);
		} else {
			input.setInstanceInitiatedShutdownBehavior(behavior);
		}
		
		input.setDisableApiTermination(btnNewButton_1.getSelection());
		input.setMonitoring(btnNewButton_2.getSelection());
		input.setEbsOptimized(btnNewButton_3.getSelection());
		
		input.setMemo(text_1.getText());
		input.setTags(editingTags);
		
		super.okPressed();
	}
	
	/**
	 * Create contents of the button bar.
	 * @param parent
	 */
	@Override
	protected void createButtonsForButtonBar(Composite parent) {
		createButton(parent, IDialogConstants.OK_ID, IDialogConstants.OK_LABEL,
				true);
		createButton(parent, IDialogConstants.CANCEL_ID,
				IDialogConstants.CANCEL_LABEL, false);
	}

	/**
	 * Return the initial size of the dialog.
	 */
	@Override
	protected Point getInitialSize() {
		return new Point(493, 679);
	}

	@Override
	protected void configureShell(Shell newShell) {
		super.configureShell(newShell);
		newShell.setText(dlgTitle);
	}
}
