package com.clustercontrol.xcloud.aws.ui.handlers;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.text.MessageFormat;

import org.apache.log4j.Logger;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.handlers.HandlerUtil;

import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.xcloud.AWSOptionEndpoint;
import com.clustercontrol.xcloud.aws.ui.dialogs.AttachSubnetDialog;
import com.clustercontrol.xcloud.common.CloudStringConstants;
import com.clustercontrol.xcloud.extensions.ICloudOptionHandler;
import com.clustercontrol.xcloud.model.cloud.INetwork;

public class AttachNetworkHandler implements ICloudOptionHandler, CloudStringConstants {
	@Override
	public Object execute(ExecutionEvent event) throws ExecutionException {
		IStructuredSelection selection = (IStructuredSelection)HandlerUtil.getActiveSite(event).getSelectionProvider().getSelection();
		final INetwork network = (INetwork)selection.getFirstElement();
		
		AttachSubnetDialog dialog = new AttachSubnetDialog(HandlerUtil.getActiveShell(event), network);
		
		loop_end:
		while(true){
			try {
				if (dialog.open() != Window.OK)
					break loop_end;
			} catch (Exception e) {
				Logger logger = Logger.getLogger(this.getClass());
				logger.error(e.getMessage(), e);

				String message = e.getMessage();
				if (message == null) {
					ByteArrayOutputStream bos = new ByteArrayOutputStream();
					PrintStream ps = new PrintStream(bos, true);
					e.printStackTrace(ps);
					
					message = bos.toString();
				}
				
				// 失敗報告ダイアログを生成
				MessageDialog.openError(null, Messages.getString("failed"), message);
				break;
			}
			
			if (MessageDialog.openConfirm(
				null,
				Messages.getString("confirmed"),
				MessageFormat.format(msgConfirmAttachNetwork, network.getName(), network.getId(),
						dialog.getInstance().getName(), dialog.getInstance().getId(),
						dialog.getNetworkInterface().getId(), dialog.getNetworkInterface().getName()))) {
				
				try {
					AWSOptionEndpoint endpoint = network.getLocation().getCloudScope().getCloudScopes().getHinemosManager().getEndpoint(AWSOptionEndpoint.class);
					
					endpoint.attachNetworkInterface(
							network.getLocation().getCloudScope().getId(),
							network.getLocation().getId(),
							dialog.getInstance().getId(),
							dialog.getNetworkInterface().getId());
					
					// 成功報告ダイアログを生成
					MessageDialog.openInformation(
						null,
						Messages.getString("successful"),
						MessageFormat.format(msgFinishAttachNetwork, network.getName(), network.getId(),
								dialog.getInstance().getName(), dialog.getInstance().getId(),
								dialog.getNetworkInterface().getId(), dialog.getNetworkInterface().getName()));
					
					Display.getCurrent().asyncExec(new Runnable() {
						@Override
						public void run() {
							network.getLocation().getComputeResources().updateNetworks();
						}
					});
					
					break loop_end;
				} catch (Exception e) {
					Logger logger = Logger.getLogger(this.getClass());
					logger.error(e.getMessage(), e);

					String message = e.getMessage();
					if (message == null) {
						ByteArrayOutputStream bos = new ByteArrayOutputStream();
						PrintStream ps = new PrintStream(bos, true);
						e.printStackTrace(ps);
						
						message = bos.toString();
					}
					
					// 失敗報告ダイアログを生成
					MessageDialog.openError(null, Messages.getString("failed"), message);
				}
			}
		}
		return null;
	}
}