/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.bridge;

import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.hibernate.search.bridge.FieldBridge;
import org.hibernate.search.bridge.StringBridge;
import org.hibernate.util.StringHelper;

public class String2FieldBridgeAdaptor
implements FieldBridge {
    private StringBridge stringBridge;

    public String2FieldBridgeAdaptor(StringBridge stringBridge) {
        this.stringBridge = stringBridge;
    }

    public void set(String name, Object value, Document document, Field.Store store, Field.Index index, Float boost) {
        String indexedString = this.stringBridge.objectToString(value);
        if (StringHelper.isNotEmpty(indexedString)) {
            Field field = new Field(name, indexedString, store, index);
            if (boost != null) {
                field.setBoost(boost.floatValue());
            }
            document.add(field);
        }
    }
}

