/*
 * Decompiled with CFR 0.152.
 */
package xml.edit;

import java.io.File;
import java.io.FileOutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;

public class EditEmptySessionPath {
    private String readFilePath;
    private String writeFilePath;

    public EditEmptySessionPath(String readFile, String outFile) {
        this.readFilePath = readFile;
        this.writeFilePath = outFile;
    }

    private boolean updateEmptySessionPath(NodeList connectors, boolean setValue) {
        String setString = Boolean.valueOf(setValue).toString();
        int i = 0;
        while (i < connectors.getLength()) {
            Element node = (Element)connectors.item(i);
            NamedNodeMap map = node.getAttributes();
            Attr protocol = (Attr)map.getNamedItem("protocol");
            Attr target = (Attr)map.getNamedItem("emptySessionPath");
            if (protocol == null || protocol.getTextContent().equals("HTTP/1.1")) {
                if (target == null) {
                    node.setAttribute("emptySessionPath", setString);
                } else {
                    target.setValue(setString);
                }
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean editServiceConnector(NodeList services, boolean setValue) {
        int i = 0;
        while (i < services.getLength()) {
            Element elem = (Element)services.item(i);
            if (this.updateEmptySessionPath(elem.getElementsByTagName("Connector"), setValue)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void execute(boolean setValue) throws Exception {
        File readFile = new File(this.readFilePath);
        DocumentBuilder docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document document = docBuilder.parse(readFile);
        this.editServiceConnector(document.getElementsByTagName("Service"), setValue);
        this.writeToFile(document);
    }

    private void writeToFile(Document document) throws Exception {
        DOMSource source = new DOMSource(document);
        File outFile = new File(this.writeFilePath);
        FileOutputStream outStream = new FileOutputStream(outFile);
        StreamResult result = new StreamResult(outStream);
        TransformerFactory trans = TransformerFactory.newInstance();
        Transformer former = trans.newTransformer();
        former.transform(source, result);
        outStream.close();
    }
}

