/*
 * Decompiled with CFR 0.152.
 */
package org.jnp.server;

import java.util.Enumeration;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import org.jboss.logging.Logger;
import org.jboss.naming.ENCFactory;
import org.jnp.interfaces.Naming;
import org.jnp.interfaces.NamingContext;
import org.jnp.server.Main;
import org.jnp.server.NamingBean;
import org.jnp.server.NamingServer;
import org.jnp.server.NamingServerWrapper;

public class NamingBeanImpl
implements NamingBean {
    private static Logger log = Logger.getLogger(NamingBeanImpl.class);
    protected Naming theServer;
    protected boolean InstallGlobalService = true;
    protected boolean UseGlobalService = true;

    public static void main(String[] args) throws Exception {
        new Main().start();
    }

    public Naming getNamingInstance() {
        return this.theServer;
    }

    public boolean getInstallGlobalService() {
        return this.InstallGlobalService;
    }

    public void setInstallGlobalService(boolean flag) {
        this.InstallGlobalService = flag;
    }

    public boolean getUseGlobalService() {
        return this.UseGlobalService;
    }

    public void setUseGlobalService(boolean flag) {
        this.UseGlobalService = flag;
    }

    public void start() throws Exception {
        if (this.theServer == null) {
            if (this.UseGlobalService) {
                this.theServer = NamingContext.localServer;
            }
            if (this.theServer == null) {
                this.theServer = new NamingServer();
            } else {
                NamingServerWrapper wrapper = new NamingServerWrapper(this.theServer);
                this.theServer = wrapper;
            }
            log.debug((Object)("Using NamingServer: " + this.theServer));
            if (this.InstallGlobalService) {
                NamingContext.setLocal(this.theServer);
                log.debug((Object)("Installed global NamingServer: " + this.theServer));
            }
        }
        InitialContext iniCtx = new InitialContext();
        Hashtable<?, ?> env = iniCtx.getEnvironment();
        log.debug((Object)"InitialContext Environment: ");
        Object providerURL = null;
        Enumeration<?> keys = env.keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            Object value = env.get(key);
            String type = value == null ? "" : value.getClass().getName();
            log.debug((Object)("key=" + key + ", value(" + type + ")=" + value));
            if (!key.equals("java.naming.provider.url")) continue;
            providerURL = value;
        }
        if (providerURL != null) {
            log.warn((Object)("Context.PROVIDER_URL in server jndi.properties, url=" + providerURL));
        }
        ClassLoader topLoader = Thread.currentThread().getContextClassLoader();
        ENCFactory.setTopClassLoader(topLoader);
        StringRefAddr refAddr = new StringRefAddr("nns", "ENC");
        Reference envRef = new Reference("javax.namingMain.Context", refAddr, ENCFactory.class.getName(), null);
        Context ctx = (Context)iniCtx.lookup("java:");
        ctx.rebind("comp", (Object)envRef);
        ctx.close();
        iniCtx.close();
    }

    public void stop() {
    }
}

