#!/bin/sh

# Copyright (C) since 2011 NTT DATA Corporation
# version 1.0
# 
# <License>
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details

# bash configuration
SCRIPT_DIR=$(cd $(dirname $0);pwd)
. ${SCRIPT_DIR}/install.cfg || exit -1

USER=`/usr/bin/whoami`

########################################
#  Local Variable
########################################
LANGUAGE=$1
HINEMOS_WEB_REVERT="${SCRIPT_DIR}/revert.sh"
echo "#!/bin/sh" > "${HINEMOS_WEB_REVERT}"

########################################
#  Local Message
########################################
# load language file
if [ ! -e ${SCRIPT_DIR}/lib/${LANGUAGE}_install.lng ]
then
  echo "not supported language : ${LANGUAGE}"
  exit 1
fi
. ${SCRIPT_DIR}/lib/${LANGUAGE}_install.lng

################################################################################
# Function
################################################################################
function checkOK() {
  echo " [OK]"
}

function checkNG() {
  echo " [NG]"
}

function existsDir() {
  if [ -e $1 ]; then
    if [ -d $1 ]; then
      return 0
    fi
  fi
  return 1
}

function utils_existsLib() {
  for (( I = 0; I < ${#APSERVER_LIB_LIST[@]}; ++I ))
  do
    existsFile "${APSERVER_LIB_LIST[$I]}/$1"
    if [ $? -eq 0 ]; then
      return 0
    fi
  done
  return 1
}

function libDiff() {
  local JARS="${HINEMOS_WEB_HOME}/lib/*.jar"
  local DIFFPATH=${APSERVER_LIB_PATH}
  local COPYPATH=${PRIVATE_WEB_LIB_DIR}
  local FILEPATH

  for FILEPATH in ${JARS}
  do
    filename=`basename ${FILEPATH}`
    utils_existsLib "${filename}"
    if [ $? -ne 0 ]; then
      cp -f ${FILEPATH} ${COPYPATH}/${filename}
    fi
  done
}

function existsFile() {
  if [ -e $1 ]; then
    if [ -f $1 ]; then
      return 0
    fi
  fi
  return 1
}

EXECUTED_BACKUP=0

function backupIfThere() {
  local DEFAULT_NAME=$1
  existsFile ${DEFAULT_NAME}
  if [ $? -eq 0 ]; then
    mv "${DEFAULT_NAME}" "${DEFAULT_NAME}_${INSTALL_TIME}"
    EXECUTED_BACKUP=1
    return $?
  fi
  EXECUTED_BACKUP=0
  return 0
}
function inputServerDir() {
  echo
  while [ 1 ]
  do
    read -p "${MSG_I030} : " INPUT
    if [ -z "${INPUT}" ]; then
      return 0
    else
      existsDir "${INPUT}"
      if [ $? -eq 0 ]; then
        APSERVER_PATH="${INPUT}"
        return 0
      fi
      
      printf "${MSG_E005}" "${INPUT}"
      echo "${MSG_W001}"
    fi
  done
  
  return 0
}
function checkAPServerPath() {
  echo
  echo ${MSG_I004}
  # inputted
  existsDir "${APSERVER_PATH}"
  if [ $? -ne 0 ]; then
    checkNG
    printf "${MSG_E005}\n" $1
    return 1
  else
    checkOK
    return 0
  fi
}
function confirmAPServerType()
{
  while [ 1 ]
  do
    echo
    echo "${MSG_I008}"
    echo "    0. Tomcat"
    echo "    1. Jboss"
  
    sleep 0.5 && read -p "${MSG_I009} " INPUT
    INPUT=${INPUT:-1}
    case ${INPUT} in
      0)
        APSERVER_TYPE=0 
        break
        ;;
      1)
        APSERVER_TYPE=1
        break
        ;;
      *)
        sleep 0.5 && read -p "${MSG_W003} : " INPUT
        case ${INPUT} in
          n|N)
            echo "${MSG_I007}"
            return 1
            ;;
          *)
            ;;
        esac
        ;;
    esac
  done
  return 0
}
function chkJava_javaVersion() {
  JAVA_VER=$(java -version 2>&1 | awk 'NR==1 { print $3 }')
  if [[ "${JAVA_VER}" =~ 1\.[5-6]\.[0-9]+ ]]; then
      return 0
  fi

  return 1
}

function chkJava_exists() {
  if type -P $1 >/dev/null
  then
    return 0
  fi

  return 1
}

function checkJavaEnv() {
  echo
  echo ${MSG_I003}
  
  chkJava_exists "java" 
  if [ $? -ne 0 ]; then
    echo ${MSG_E003A} ${MSG_E003} && echo ${MSG_E004}
    return 1
  fi
  
  chkJava_javaVersion 
  if [ $? -ne 0 ]; then
    echo ${MSG_E003} && echo ${MSG_E004}
    return 1
  fi
  
  chkJava_exists "jar"
  if [ $? -ne 0 ]; then
    echo ${MSG_E003B} ${MSG_E003} && echo ${MSG_E004}
    return 1
  fi
  
  checkOK
  return 0
}
function checkUser()
{
  # check user executed
  echo
  echo ${MSG_I002}
  if [ "x"$1 != "xroot" ]
  then
    EchoNG
    echo ${MSG_E002} && echo ${MSG_E004}
    return 1
  fi
  checkOK

  return 0
}
function checkHinemosEnv() {
  local HINEMOS_VERSION
  local VERINFO=${HINEMOS_HOME}/_version

  echo
  echo ${MSG_I026}
  if [ -e ${HINEMOS_HOME} -a -f ${VERINFO} ]; then
    HINEMOS_VERSION=`cat ${VERINFO}`
    if [[ ${HINEMOS_VERSION} =~ ^3\.[12]\. ]]; then
      checkOK
      return 0
    else
      checkNG
      echo ${MSG_E007}
      echo ${MSG_E004}
      return 1
    fi
  fi
  # not found hinemos.
  checkOK
  return 0
}
function checkEnvironment() {
  # check user executed
  checkUser ${USER}\
    && checkJavaEnv\
    && checkHinemosEnv
  
  if [ $? -ne 0 ]; then
    return 1
  fi
  
  return 0
}
function chkUpd_versionup() {
  local CURRENT_VERSION
  
  if [ ! -f ${HINEMOS_WEB_HOME}/_version ]; then
    # cannot find version info.
    echo "${MSG_I013}"
    return 1
  else
    CURRENT_VERSION=`cat ${HINEMOS_WEB_HOME}/_version`
    echo
    printf "${MSG_I005}" ${CURRENT_VERSION}
    echo "${MSG_I027}"
    while [ 1 ]
    do
      read -p "${MSG_I028} :" INPUT
      INPUT=${INPUT:-N}
      case ${INPUT} in
        y|Y)
          break
          ;;
        n|N)
          echo ${MSG_E004}
          return 1
          ;;
        *)
          echo ${MSG_W001}
          ;;
      esac
    done
    return 0
  fi
}

function checkUpdated() {
  existsDir ${HINEMOS_WEB_HOME}
  if [ $? -ne 0 ]; then
    # does not exists.
    IS_UPDATE=0
    return 0
  else
    # already exists.
    echo ${MSG_W002}
    IS_UPDATE=1
    chkUpd_versionup
    return $?
  fi
}
function confirmInstallation()
{
	echo
  local INPUT
	while [ 1 ]
	do
		sleep 0.5 && read -p "${MSG_I001} : " INPUT
		INPUT=${INPUT:-Y}
		case ${INPUT} in
			y|Y)
				break
				;;
			n|N)
				echo ${MSG_I007}
				return 1
				;;
			*)
				echo ${MSG_W001}
				;;
		esac
	done
	return 0
}
function chkInf_chkDirExists() {
  local CHECK_PATH=$1
  local ERROR_MSG=$2
  existsDir "${CHECK_PATH}"
  if [ $? -ne 0 ]; then
    chkInf_dispError "${ERROR_MSG}" "${CHECK_PATH}"
    return 1
  fi
  return 0
}

function chkInf_dispError() {
  echo
  printf "$1\n" "$2"
  echo "${MSG_E004}"
}

########################################
# setting environment for tomcat.
########################################
function chkInf_setTomcatEnv() {
  chkInf_detectTomcatLib \
    && chkInf_detectDeploy \
    && chkInf_setTomServerXml
  if [ $? -ne 0 ]; then
    return 1
  fi
}

function chkInf_setTomServerXml() {
  local DEFAULT_SERVER_XML="${APSERVER_PATH}/conf/server.xml"
  existsFile "${DEFAULT_SERVER_XML}"
  if [ $? -eq 0 ]; then
    APSERVER_CONF_XML="${DEFAULT_SERVER_XML}"
  fi
}

function chkInf_detectDeploy() {
  local TOMCAT_CONF="${APSERVER_PATH}/conf"
  local CATALINA_HOME="${TOMCAT_CONF}/Catalina"
  APSERVER_DEPLOY_PATH="${CATALINA_HOME}/${VIRTUAL_HOST}"
  chkInf_chkDirExists "${TOMCAT_CONF}" "${MSG_E102}"
  return $?
}

function chkInf_detectTomcatLib() {
  local TOMCAT_LIB_LIST=(\
    "${APSERVER_PATH}/lib" \
    "${APSERVER_PATH}/server/lib" \
    "${APSERVER_PATH}/common/lib" \
    "${APSERVER_PATH}/shared/lib")
  
  for (( I = 0; I < ${#TOMCAT_LIB_LIST[@]}; ++I ))
  do
    existsDir "${TOMCAT_LIB_LIST[$I]}"
    if [ $? -eq 0 ]; then
      APSERVER_LIB_LIST=("${APSERVER_LIB_LIST[@]}" "${TOMCAT_LIB_LIST[$I]}")
    fi
  done
  
  if [ ${#APSERVER_LIB_LIST[@]} -eq 0 ]; then
    chkInf_dispError "${MSG_E101}" "${BASE_PATH}"
    return 1
  fi
  
  return 0
}

########################################
# setting environment for jboss
########################################
function chkInf_setJBossEnv() {
  chkInf_checkJBossDirs
  chkInf_setJServerXml
}

function chkInf_setJServerXml() {
  # JBoss 4.2.x-6.0.x
  local JBOSS_XML_LIST=(\
    "${APSERVER_DEPLOY_PATH}/jboss-web.deployer/server.xml"\
    "${APSERVER_DEPLOY_PATH}/jbossweb.sar/server.xml"\
  )
  for (( I = 0; I < ${#JBOSS_XML_LIST[@]}; ++I ))
  do
    existsFile "${JBOSS_XML_LIST[$I]}"
    if [ $? -eq 0 ]; then
      APSERVER_CONF_XML="${JBOSS_XML_LIST[$I]}"
      return 0
    fi
  done
}

function chkInf_setJbossLibDirs() {
  local JBOSS_LIB_LIST=(\
    "$1/lib" \
    "${APSERVER_DEPLOY_PATH}/jboss-web.deployer" \
    "${APSERVER_PATH}/client")
  for (( I = 0; I < ${#JBOSS_LIB_LIST[@]}; ++I ))
  do
    existsDir "${JBOSS_LIB_LIST[$I]}"
    if [ $? -eq 0 ]; then
      APSERVER_LIB_LIST=("${APSERVER_LIB_LIST[@]}" "${JBOSS_LIB_LIST[$I]}")
    fi
  done
}

function chkInf_checkSetJbossPathes() {
  APSERVER_DEPLOY_PATH="$1/deploy"
  chkInf_setJbossLibDirs "$1"
  
  if [ ${#APSERVER_LIB_LIST[@]} -eq 0 ]; then
    chkInf_dispError "${MSG_E203}" "${APSERVER_DEPLOY_PATH}"
    return 1
  fi
  
  chkInf_chkDirExists "${APSERVER_DEPLOY_PATH}" "${MSG_E204}" \
    && chkInf_chkDirExists "$1/lib" "${MSG_E203}"
  return $?
}

function chkInf_checkJBossDirs() {
  local SERVER_DIR="${APSERVER_PATH}/server/*"
  local TARGET
  local INDEX=0
  local INSTALL_TGT=()
  
  echo
  echo "${MSG_I015}"
  for TARGET in ${SERVER_DIR}
  do
    existsDir "${TARGET}"
    if [ $? -eq 0 ]; then
      INSTALL_TGT=("${INSTALL_TGT[@]}" "${TARGET}")
      echo "    ${INDEX}. ${TARGET}"
      INDEX=`expr ${INDEX} + 1`
    fi
  done
  
  if [ ${#INSTALL_TGT[@]} -eq 0 ]; then
    echo "${MSG_E204}"
    return 1
  fi
  
	while [ 1 ]
	do
    read -p "${MSG_I016} :" INPUT
    INPUT=${INPUT:-0}
    if [ ${INPUT} -lt ${INDEX} ]; then
      chkInf_checkSetJbossPathes "${INSTALL_TGT[${INPUT}]}"
      return $?
    fi
    echo "${MSG_W001}"
  done
}

########################################
# display and setting env.
########################################
function setOtherEnvs() {
  if [ ${APSERVER_TYPE} -eq 0 ]; then
    chkInf_setTomcatEnv
  else
    chkInf_setJBossEnv
  fi
}
function confInf_displayEditServer() {
  local UPDATE_TOKEN=""
  if [ ${EDIT_SERVER_XML} -eq 0 ]; then
    UPDATE_TOKEN="Yes"
  else
    UPDATE_TOKEN="No"
  fi
  printf "${MSG_I035}\n" "${UPDATE_TOKEN}"
  printf "${MSG_I036}\n" "${APSERVER_CONF_XML}"
}

function checkInfomation() {
  echo
  echo "${MSG_I017}"
  echo "${MSG_I018}"
  printf "${MSG_I019}\n" "${APSERVER_TYPE}"
  printf "${MSG_I020}\n" "${APSERVER_PATH}"
  printf "${MSG_I021}\n" "${APSERVER_DEPLOY_PATH}"
  echo "${MSG_I022}"
  for (( I = 0; I < ${#APSERVER_LIB_LIST[@]}; ++I ))
  do
    printf "${MSG_I029}\n" "${APSERVER_LIB_LIST[$I]}"
  done
  echo "${MSG_I023}"
  echo "${MSG_I024}"
  confInf_displayEditServer
  read -p "${MSG_I025} : " INPUT
  INPUT=${INPUT:-Y}
  case ${INPUT} in
    y|Y)
      break
      ;;
    n|N)
      echo "${MSG_E004}"
      return 1
      ;;
    *)
      ;;
  esac
  return 0
}
function welcome()
{
	VERSION=`cat ${SCRIPT_DIR}/hinemos_web/_version`
	echo
	echo "-------------------------------------------------------"
	echo "   Welcome to the installation for Hinemos Web Client"
	echo "                             Version ${VERSION}"
	echo
	echo "       Copyright (C) NEC Corporation 2012. All Rights Reserved."
	echo "-------------------------------------------------------"
}
function mkdirExists() {
  existsDir $1
  if [ $? -ne 0 ]; then
    mkdir -p $1
  fi
  return 0
}

function copyFiles()
{
  echo

  #Create Path for Hinemos Web home
  echo "${MSG_I010}"
  PATH_TO_HINEMOS_WEB_HOME=$(echo "${HINEMOS_WEB_HOME}" | sed -e "s/\//\\\\\//g")  
  if [ $? -ne 0 ]
  then
    checkNG
    echo "${MSG_E004}"
    return 1
  fi
  
  existsDir "${HINEMOS_WEB_HOME}"
  if [ $? -ne 0 ]
  then
    echo ${MSG_I011}
    mkdir -p ${HINEMOS_WEB_HOME}
  fi
  
  existsDir ${HINEMOS_WEB_WAR}
  if [ $? -eq 0 ]; then
    rm -rf ${HINEMOS_WEB_WAR}
  fi
  
  echo ${MSG_I012}
  
  # copy all.
  cp -pfr ${SCRIPT_DIR}/hinemos_web/* ${HINEMOS_WEB_HOME} \
    && mkdirExists ${HINEMOS_WEB_SBIN}/lib \
    && cp -pf ${SCRIPT_DIR}/install.cfg ${HINEMOS_WEB_SBIN} \
    && cp -pfr ${SCRIPT_DIR}/uninstall* ${HINEMOS_WEB_SBIN} \
    && cp -pfr ${SCRIPT_DIR}/webclient_uninstaller_* ${HINEMOS_WEB_SBIN} \
    && cp -pfr ${SCRIPT_DIR}/lib/*_uninstall.lng ${HINEMOS_WEB_SBIN}/lib \
    && cat "${SCRIPT_DIR}/lib/log4j.properties" | sed -e "s/\${hinemos\.web\.home}/${PATH_TO_HINEMOS_WEB_HOME}/g"\
      > "${HINEMOS_WEB_HOME}/etc/log4j.properties" \
    && $(cd ${PRIVATE_WEB_INF_DIR}/classes && cp -f ../../../etc/hinemos_web.cfg ./ && cp -f ../../../etc/log4j.properties ./)
  
  if [ $? -ne 0 ]
  then
    checkNG
    echo ${MSG_E004}
    return 1
  fi
  checkOK

  return 0
}
#############################
# edit server.xml functions
#############################
function confirmEditServerXml() {
  echo
  echo "${MSG_I032}"
  while [ 1 ]
  do
    read -p "${MSG_I031}: " INPUT
    INPUT=${INPUT:-Y}
    case ${INPUT} in
      y|Y)
        EDIT_SERVER_XML=0
        return 0
        ;;
      n|N)
        EDIT_SERVER_XML=1
        return 0
        ;;
      *)
        echo "${MSG_W001}"
        ;;
    esac
  done
}

function editXml_backup() {
  echo
  printf "${MSG_I033}\n" "${APSERVER_CONF_XML}"
  backupIfThere "${APSERVER_CONF_XML}"
  if [ $? -eq 0 ]; then
    checkOK
    return 0
  else
    checkNG
    return 1
  fi
}

function editXml_edit() {
  echo
  printf "${MSG_I034}\n" "${APSERVER_CONF_XML}"
  java -jar "${SCRIPT_DIR}/lib/editXml.jar" "${APSERVER_CONF_XML}_${INSTALL_TIME}" "${APSERVER_CONF_XML}"
  if [ $? -eq 0 ]; then
    checkOK
    return 0
  else
    checkNG
    mv "${APSERVER_CONF_XML}_${INSTALL_TIME}" "${APSERVER_CONF_XML}"
    return 1
  fi
}

function updateServerXml() {
  # return if not update or cannot detect server config.
  if [ ${EDIT_SERVER_XML} -ne 0 ];then
    return 0
  fi
  if [ -z "${APSERVER_CONF_XML}" ];then
    echo "${MSG_W004}"
    return 0
  fi

  # backup to edit.
  editXml_backup\
    && editXml_edit

  if [ $? -eq 0 ]; then
    echo "EDITED_XML=\"${APSERVER_CONF_XML}\"" >> "${HINEMOS_WEB_SBIN}/install.cfg"
    return 0
  fi
  
  echo "${MSG_W004}"
  echo "EDITED_XML=\"\"" >> "${HINEMOS_WEB_SBIN}/install.cfg"
  return 1
}
function SIGINTExit()
{
  echo "echo" >> ${HINEMOS_WEB_REVERT}
	echo "echo \"${MSG_E004} (SIGINT)\"" >> ${HINEMOS_WEB_REVERT}
}

function copyStopped() {
  echo "echo" >> ${HINEMOS_WEB_REVERT}
  if [ ${IS_UPDATE} -eq 0 ]
  then
    echo "echo \"${MSG_I006}\"" >> ${HINEMOS_WEB_REVERT}
    echo "rm -rf ${HINEMOS_WEB_HOME}" >> ${HINEMOS_WEB_REVERT}
    echo "echo ' [OK]'" >> ${HINEMOS_WEB_REVERT}
  fi
	echo "echo \"${MSG_E004} (SIGINT)\"" >> ${HINEMOS_WEB_REVERT}
}

#########################################################
# SIGINT trap
#########################################################
function sigintHandler() {
  /bin/sh ${HINEMOS_WEB_REVERT}
  exit 1
}

trap sigintHandler 2

#########################################################
# JBossInstallation
#########################################################
function jbs_checkEnvironment() {
  echo
  echo "${MSG_I201}"
  existsDir "${APSERVER_DEPLOY_PATH}"
  if [ $? -ne 0 ]; then
    checkNG
    printf "${MSG_E204}\n" "${APSERVER_DEPLOY_PATH}"
    return 1
  fi
  checkOK
  
  echo
  echo "${MSG_I202}"
  if [ ${#APSERVER_LIB_LIST[@]} -eq 0 ]; then
    checkNG
    printf "${MSG_E203}" ""
    return 1
  fi
  checkOK
  
  CREATE_WAR_NAME="${APSERVER_DEPLOY_PATH}/hinemos_web.war"
  
  return 0
}

function jbs_copyLibraries() {
  echo
  echo "${MSG_I202}"
  echo "${MSG_I204}"
  libDiff
  checkOK
}

function jbs_createConfig() {
  echo
  echo "${MSG_I203}"
  cat "${SCRIPT_DIR}/lib/jboss-web.xml" | sed -e "s#\${virtual\.host}#${VIRTUAL_HOST}#g"\
    | sed -e "s#\${context\.root}#${CONTEXT_ROOT}#g" > "${PRIVATE_WEB_INF_DIR}/jboss-web.xml"
  if [ $? -ne 0 ]; then
    checkNG
    echo "${MSG_E201}"
    return $?
  else
    checkOK
    return 0
  fi
}

function jbs_backupCurrentWar() {
  echo
  echo "${MSG_I205}"
  existsFile "${CREATE_WAR_NAME}"
  checkOK
  if [ $? -eq 0 ]; then
    echo
    echo "${MSG_I206}"
    backupIfThere "${CREATE_WAR_NAME}"
    if [ $? -ne 0 ]; then
      checkNG
      echo "${MSG_E202}"
      return 1
    else
      checkOK
      return 0
    fi
  fi
}

function jbs_revertInstall() {
  echo "mv -f \"${CREATE_WAR_NAME}_${INSTALL_TIME}\" \"${CREATE_WAR_NAME}\"" > ${HINEMOS_WEB_REVERT}
  copyStopped
}

function jbs_createWar() {
  echo
  echo "${MSG_I207}"

  rm -f ${CREATE_WAR_NAME}
  jar cvf ${CREATE_WAR_NAME} -C ${HINEMOS_WEB_WAR}/ . > "${HINEMOS_WEB_SBIN}/jar_command.log"
  chmod +xr ${CREATE_WAR_NAME}
  
  echo "DEPLOYED_FILE_PATH=\"${CREATE_WAR_NAME}\"" >> "${HINEMOS_WEB_SBIN}/install.cfg"
}

function jbossInstall() {
  echo
  echo "${MSG_I200}"
  
  jbs_checkEnvironment
  if [ $? -ne 0 ]; then
    echo "${MSG_E004}"
    return 1
  fi
  
  jbs_copyLibraries
  
  jbs_createConfig
  if [ $? -ne 0 ]; then
    echo "${MSG_E004}"
    return 1
  fi
  
  jbs_revertInstall
  
  # backup if first install only.
  # don't execute on update install.
  if [ ${IS_UPDATE} -eq 0 ]; then
    jbs_backupCurrentWar
    if [ $? -ne 0 ]; then
      echo "${MSG_E004}"
      return 1
    fi
    echo "${INSTALL_TIME}" > "${SERVER_INFORM_PATH}"
  fi
  
  jbs_createWar
  if [ $? -ne 0 ]; then
    echo "${MSG_E004}"
    return 1
  fi
}

#########################################################
# Tomcat installation
#########################################################
function tmc_checkInvitonment() {
  echo
  echo ${MSG_I101}
  existsDir ${APSERVER_PATH}
  if [ $? -ne 0 ]; then
    checkNG
    printf "${MSG_E005}\n" ${APSERVER_PATH}
    return 1
  fi
  checkOK
  
  echo
  echo ${MSG_I102}
  if [ ${#APSERVER_LIB_LIST[@]} -eq 0 ]; then
    checkNG
    printf "${MSG_E101}" ""
    return 1
  fi
  checkOK
  
  return 0
}

function tmc_copyLibraries() {
  echo
  echo ${MSG_I103}
  libDiff
  checkOK
}

function tmc_setVirtualHost() {
  if [ -z ${VIRTUAL_HOST} ]; then
    printf "${MSG_I104}\n" "localhost"
    VIRTUAL_HOST="localhost"
  else
    printf "${MSG_I105}\n" ${VIRTUAL_HOST}
  fi
}

function tmc_checkDeployDir() {
  existsDir ${APSERVER_DEPLOY_PATH}
  if [ $? -ne 0 ]; then
    # have to create
    echo "${MSG_I107}"
    mkdir -p ${APSERVER_DEPLOY_PATH}
    if [ $? -ne 0 ]; then
      printf "${MSG_E103}" ${APSERVER_DEPLOY_PATH}
      return 1
    fi
  else
    # already exists.
    echo "${MSG_I106}"
  fi
  
  return 0
}

function tmc_checkContextRootFile() {
  if [ -n ${CONTEXT_ROOT} ]; then
    if [ ${CONTEXT_ROOT} = "/" ]; then
      CONTEXT_ROOT_FILE="root.xml"
      WRITE_CONTEXT_ROOT=""
    else
      CONTEXT_ROOT_FILE="${CONTEXT_ROOT}.xml"
      WRITE_CONTEXT_ROOT="path=\"${CONTEXT_ROOT}\""
    fi
  else
    CONTEXT_ROOT_FILE="root.xml"
    WRITE_CONTEXT_ROOT=""
  fi
  CONTEXT_ROOT_FILE="${APSERVER_DEPLOY_PATH}/${CONTEXT_ROOT_FILE}"
}

function tmc_createContextFile() {
  echo
  echo "${MSG_I110}"
  cat "${SCRIPT_DIR}/lib/tomcat-context.xml" | sed -e "s#\${path\.to\.hinemos\.web}#${HINEMOS_WEB_WAR}#g"\
		| sed -e "s#\${context\.root}#${WRITE_CONTEXT_ROOT}#g" > "${CONTEXT_ROOT_FILE}"
  return $?
}

function tmc_createContext() {
  tmc_setVirtualHost
  
  tmc_checkDeployDir
  if [ $? -ne 0 ]; then
    return 1
  fi
  
  # backup if first install only.
  # don't execute on update install.
  if [ ${IS_UPDATE} -eq 0 ]; then
    printf "${MSG_I108}\n" ${CONTEXT_ROOT_FILE}
    printf "${MSG_I109}\n" ${CONTEXT_ROOT_FILE}
    backupIfThere ${CONTEXT_ROOT_FILE}
    if [ $? -ne 0 ]; then
      echo ${MSG_E104}
      return 1
    fi
    echo "${INSTALL_TIME}" > "${SERVER_INFORM_PATH}"
  fi
  
  tmc_createContextFile
  if [ $? -ne 0 ]; then
    return 1
  fi
  
  echo "DEPLOYED_FILE_PATH=\"${CONTEXT_ROOT_FILE}\"" >> "${HINEMOS_WEB_SBIN}/install.cfg"
  return 0
}

function tmc_revertInstall() {
  echo "mv -f \"${CONTEXT_ROOT_FILE}_${INSTALL_TIME}\" \"${CONTEXT_ROOT_FILE}\"" > ${HINEMOS_WEB_REVERT}
  copyStopped
}

function tomcatInstall() {
  echo
  echo ${MSG_I100}
  
  tmc_checkInvitonment
  if [ $? -ne 0 ]; then
    echo "${MSG_E004}"
    return 1
  fi
  
  tmc_copyLibraries
  
  tmc_checkContextRootFile
  
  tmc_revertInstall
  
  tmc_createContext
  if [ $? -ne 0 ]; then
    echo "${MSG_E004}"
    return 1
  fi
}

################################################################################
# SHELL
################################################################################

# check installation env params.
checkEnvironment || exit 2

# display welcome
welcome

# trapping exit code.
SIGINTExit

# check update.
checkUpdated || exit 5

# install or not?
confirmInstallation || exit 6

# check path settings.
inputServerDir || exit 3

# check path settings.
checkAPServerPath || exit 4

# get ap server type.
confirmAPServerType || exit 7

# setting other envs.
setOtherEnvs || exit 8

# server.xml update?
confirmEditServerXml

# checkking before install.
checkInfomation || exit 9

# trapping exit code.
copyStopped

# copy files
copyFiles
if [ $? -ne 0 ]; then
  /bin/sh ${HINEMOS_WEB_REVERT}
  exit 10
fi

# execution install
if [ ${APSERVER_TYPE} -eq 0 ]; then
  # tomcat install
  tomcatInstall
  if [ $? -ne 0 ]; then
    /bin/sh ${HINEMOS_WEB_REVERT}
    exit 11
  fi
else
  # jboss install
  jbossInstall
  if [ $? -ne 0 ]; then
    /bin/sh ${HINEMOS_WEB_REVERT}
    exit 12
  fi
fi

# update server.xml
updateServerXml

# end of hinemos web installation.
echo "${MSG_I099}"
echo "${MSG_I300}"

