#!/bin/sh

# Copyright (C) since 2011 NEC Corporation
# version 1.0
# 
# <License>
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# <License>

SCRIPT_DIR=$(cd $(dirname $0);pwd)
. ${SCRIPT_DIR}/install.cfg || exit -1

USER=`/usr/bin/whoami`

########################################
#  Local Variable
########################################
if [ "x"$1 == "x-f" ]
then
  LANGUAGE=$2
  FORCE_UNINSTALL=true
else
  LANGUAGE=$1
fi

########################################
#  Local Message
########################################

# load language file
if [ ! -e ${SCRIPT_DIR}/lib/${LANGUAGE}_uninstall.lng ]
then
  output "not supported language : ${LANGUAGE}"
  exit -1
fi
. ${SCRIPT_DIR}/lib/${LANGUAGE}_uninstall.lng

################################################################################
# Function
################################################################################
function checkOK() {
  echo " [OK]"
}

function checkNG() {
  echo " [NG]"
}

function existsDir() {
  if [ -e $1 ]; then
    if [ -d $1 ]; then
      return 0
    fi
  fi
  return 1
}

function existsFile() {
  if [ -e $1 ]; then
    if [ -f $1 ]; then
      return 0
    fi
  fi
  return 1
}

function welcome()
{
  if [ -e ${HINEMOS_WEB_HOME}/_version ]
  then
    VERSION=`cat ${HINEMOS_WEB_HOME}/_version`
  else
    VERSION="UNKNOWN"
  fi
  echo
  echo "-------------------------------------------------------"
  echo "     Uninstaller for Hinemos Web Client"
  echo "                             Version ${VERSION}"
  echo
  echo "       Copyright (C) NEC Corporation 2012. All Rights Reserved."
  echo "-------------------------------------------------------"
}
function checkUser()
{
  # check user executed
  echo
  echo "${MSG_I001}"
  if [ "x"$1 != "xroot" ]
  then
    checkNG
    echo ${MSG_E001} && echo ${MSG_I002}
    return 1
  fi
  checkOK

  return 0
}
REMOVE_TARGET=""
REVERT_TARGET=""
REMOVE_DIRS=""
REVERT_XML=""

function chkRmv_checkRemoveFiles() {
  echo
  echo "${MSG_I003}"

  existsFile ${DEPLOYED_FILE_PATH}
  if [ $? -eq 0 ]; then
    checkOK
    REMOVE_TARGET="${DEPLOYED_FILE_PATH}"
    return 0
  fi
  
  checkNG
  echo "${MSG_E002}"
  return 1
}

function chkRmv_checkRevertFile() {
  echo
  echo "${MSG_I004}"
  
  local TIME_SUFIX=`cat ${SCRIPT_DIR}/_server`
  
  # there's no backup files.
  chkRmv_checkRevertDep "${TIME_SUFIX}"
  chkRmv_checkRevertXml "${TIME_SUFIX}"
  
  if [ $? -eq 1 ]; then
    if [ -z ${REVERT_TARGET} ]; then
      echo "${MSG_I005}"
    fi
  fi
  
  return 0
}

function chkRmv_checkRevertDep() {
  local TGT_FILE="${DEPLOYED_FILE_PATH}_$1"
  existsFile ${TGT_FILE}
  if [ $? -eq 0 ]; then
    REVERT_TARGET=${TGT_FILE}
  else
    REVERT_TARGET=""
  fi
}

function chkRmv_checkRevertXml() {
  if [ -z "${EDITED_XML}" ]; then
    return 0
  fi

  REVERT_XML="${EDITED_XML}_$1"
  existsFile "${REVERT_XML}"
  if [ $? -ne 0 ]; then
    REVERT_XML=""
    return 1
  fi
  return 0
}

function chkRmv_checkRemoveDirs() {
  echo
  echo "${MSG_I006}"
  
  existsDir ${HINEMOS_WEB_HOME}
  if [ $? -eq 0 ]; then
    checkOK
    REMOVE_DIRS="${HINEMOS_WEB_HOME}"
    return 0
  fi
  checkNG
  echo "${MSG_E005}"
  return 1
}

function checkRemoveTarget() {
  chkRmv_checkRemoveDirs \
    && chkRmv_checkRemoveFiles
  if [ $? -ne 0 ]; then
    echo "${MSG_I002}"
    return 1
  fi
  
  chkRmv_checkRevertFile
  
  return 0
}
function notice() {
  local DIR_NAME
  
  echo
  echo "${MSG_I009}"
  printf "${MSG_I010}\n" "${REMOVE_TARGET}"
  printf "${MSG_I013}\n" "${REVERT_XML}"
  printf "${MSG_I011}\n" "${REVERT_TARGET}"
  printf "${MSG_I012}\n" "${REMOVE_DIRS}"
  
  echo
  echo "${MSG_I008}"
}
function confirmUninstallation() {
  echo
  while [ 1 ]
  do
    sleep 0.5 && read -p "${MSG_I007} : " INPUT
    INPUT=${INPUT:-N}
    case ${INPUT} in
      y|Y)
        break
        ;;
      n|N)
        echo ${MSG_I002}
        return -1
        ;;
      *)
        echo ${MSG_W001}
        ;;
    esac
  done
  return 0
}
function exe_removeDeployFile() {
  echo
  echo "${MSG_I014}"
  rm -f "${REMOVE_TARGET}"
  if [ $? -ne 0 ]; then
    checkNG
    printf "${MSG_E003}" "${REMOVE_TARGET}"
    return 1
  fi
  checkOK
  return 0
}

function exe_revertDeployed() {
  if [ -z ${REVERT_TARGET} ]; then
    return 0
  else
    mv -f "${REVERT_TARGET}" "${REMOVE_TARGET}"
    if [ $? -ne 0 ]; then
      checkNG
      printf "${MSG_E004}" "${REMOVE_TARGET}"
      return 1
    fi
    return 0
  fi
}

function exe_revertServerXml() {
  if [ -z ${REVERT_XML} ]; then
    return 0
  else
    mv -f "${REVERT_XML}" "${EDITED_XML}"
    if [ $? -ne 0 ]; then
      checkNG
      printf "${MSG_E004}" "${REVERT_XML}"
      return 1
    fi
    return 0
  fi
}

function exe_revertBackup() {
  echo
  echo "${MSG_I015}"

  exe_revertDeployed\
    && exe_revertServerXml
  
  if [ $? -eq 0 ]; then
    checkOK
    return 0
  fi
  return 1
}

function exe_removeDirs() {
  echo
  echo "${MSG_I018}"
  rm -rf "${HINEMOS_WEB_HOME}"
  if [ $? -ne 0 ]; then
    checkNG
    echo "${MSG_E006}"
    echo "${MSG_W002}"
    return 1
  fi
  checkOK
  return 0
}

function executeUninstall() {
  exe_removeDeployFile \
    && exe_revertBackup \
    && exe_removeDirs
  
  if [ $? -ne 0 ]; then
    echo "${MSG_I002}"
    return 1
  fi
  return 0
}

################################################################################
# Shell
################################################################################

checkUser ${USER} || exit 1

checkRemoveTarget || exit 2

welcome

notice

# confirm uninstallation
if [ "x"${FORCE_UNINSTALL} != "xtrue" ] 
then
  confirmUninstallation || exit 3
fi

executeUninstall || exit 4

echo
echo ${MSG_I016}
echo ${MSG_I017}

