/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License 
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied 
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 PURPOSE.  See the GNU General Public License for more details.
 
 */

package com.clustercontrol.jobmanagement.bean;

import java.util.ArrayList;

import com.clustercontrol.util.Messages;


/**
 * ジョブのジョブ変数におけるシステム変数に関する情報を定義するクラス<BR>
 * 
 * @version 2.1.0
 * @since 2.1.0
 */
public class SystemParameterConstant {
	/** 呼び出し元のファシリティID */
	public static final String FACILITY_ID = "FACILITY_ID";
	/** 呼び出し元のプラグインID */
	public static final String PLUGIN_ID = "PLUGIN_ID";
	/** 呼び出し元の監視項目ID */
	public static final String MONITOR_ID = "MONITOR_ID";
	/** 呼び出し元のメッセージID */
	public static final String MESSAGE_ID = "MESSAGE_ID";
	/** 呼び出し元のアプリケーション */
	public static final String APPLICATION = "APPLICATION";
	/** 呼び出し元の重要度 */
	public static final String PRIORITY = "PRIORITY";
	/** 呼び出し元のメッセージ */
	public static final String MESSAGE = "MESSAGE";
	/** 呼び出し元のオリジナルメッセージ */
	public static final String ORG_MESSAGE = "ORG_MESSAGE";
	/** ジョブセッション開始日時 */
	public static final String START_DATE = "START_DATE";
	
	public static final String SESSION_ID = "SESSION_ID";
	public static final String TRIGGER_TYPE = "TRIGGER_TYPE";
	public static final String TRIGGER_INFO = "TRIGGER_INFO";
	
	
	/** ジョブ変数 ヘッダー */
	public static final String HEADER = "${";
	/** ジョブ変数 ヘッダー 正規表現 */
	public static final String HEADER_REGEX = "\\$\\{";
	/** ジョブ変数 フッター */
	public static final String FOOTER = "}";
	/** ジョブ変数 フッター 正規表現 */
	public static final String FOOTER_REGEX = "\\}";
	
	
	public static final ArrayList<ArrayList<String>> ALL = 
		new ArrayList<ArrayList<String>>() {{
			add(new ArrayList<String>() {{
				add(FACILITY_ID);add(Messages.getString("facility.id"));}});
			add(new ArrayList<String>() {{
				add(PLUGIN_ID);add(Messages.getString("plugin.id"));}});
			add(new ArrayList<String>() {{
				add(MONITOR_ID);add(Messages.getString("monitor.id"));}});
			add(new ArrayList<String>() {{
				add(MESSAGE_ID);add(Messages.getString("message.id"));}});
			add(new ArrayList<String>() {{
				add(APPLICATION);add(Messages.getString("application"));}});
			add(new ArrayList<String>() {{
				add(PRIORITY);add(Messages.getString("priority"));}});
			add(new ArrayList<String>() {{
				add(MESSAGE);add(Messages.getString("message"));}});
			add(new ArrayList<String>() {{
				add(ORG_MESSAGE);add(Messages.getString("message.org"));}});
			add(new ArrayList<String>() {{
				add(START_DATE);add(Messages.getString("start.time"));}});
			add(new ArrayList<String>() {{
				add(SESSION_ID);add(Messages.getString("session.id"));}});
			add(new ArrayList<String>() {{
				add(TRIGGER_TYPE);add(Messages.getString("trigger.type"));}});
			add(new ArrayList<String>() {{
				add(TRIGGER_INFO);add(Messages.getString("trigger.info"));}});
		}};
}